/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlManyToMany_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmManyToManyMapping;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0OrmManyToManyMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0OrmManyToManyMappingTests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestTypeWithCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"java.util.Collection"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    private Collection<Foo> manyToManyMapping;").append(CR);
            }
        });
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        manyToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNotNull((Object)manyToMany.getMapKey());
        manyToMany.getMapKey().setName("myMapKey");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName("myMapKey");
        manyToMany.setMapKey(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setPkMapKey(true);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)virtualManyToManyMapping.getMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isPkMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setCustomMapKey(true);
        javaManyToManyMapping.setSpecifiedMapKey("city");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.isCustomMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        ormManyToManyMapping.setSpecifiedMapKey("myMapKey");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        ormManyToManyMapping.setSpecifiedMapKey(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey().getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        OrmManyToManyMapping specifiedManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        specifiedManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        specifiedManyToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = specifiedManyToManyMapping.getCandidateMapKeyNames().iterator();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKeyClass());
        manyToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNotNull((Object)manyToMany.getMapKeyClass());
        manyToMany.getMapKeyClass().setClassName("String");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"String", (String)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"String", (String)manyToMany.getMapKeyClass().getClassName());
        manyToMany.getMapKeyClass().setClassName(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKeyClass().getClassName());
        manyToMany.getMapKeyClass().setClassName("String");
        manyToMany.setMapKeyClass(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping2_0 virtualManyToManyMapping = (ManyToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getDefaultMapKeyClass());
        javaManyToManyMapping.setSpecifiedMapKeyClass("Integer");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"Integer", (String)virtualManyToManyMapping.getMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"Integer", (String)virtualManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKeyClass());
        ormManyToManyMapping.setSpecifiedMapKeyClass("String");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"String", (String)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"String", (String)manyToMany.getMapKeyClass().getClassName());
        ormManyToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType printQueuePersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        OrmSpecifiedPersistentAttribute jobsPersistentAttribute = printQueuePersistentType.addAttributeToXml(printQueuePersistentType.getAttributeNamed("jobs"), "manyToMany");
        OrmManyToManyMapping jobsMapping = (OrmManyToManyMapping)jobsPersistentAttribute.getMapping();
        jobsMapping.getRelationship().setStrategyToMappedBy();
        jobsMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("queues");
        OrmPersistentType printJobPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute queuesPersistentAttribute = printJobPersistentType.addAttributeToXml(printJobPersistentType.getAttributeNamed("queues"), "manyToMany");
        OrmManyToManyMapping queuesMapping = (OrmManyToManyMapping)queuesPersistentAttribute.getMapping();
        this.getOrmXmlResource().save(null);
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        SpecifiedOrderColumn2_0 jobsOrderColumn = jobsOrderable.getOrderColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        SpecifiedOrderColumn2_0 queuesOrderColumn = queuesOrderable.getOrderColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        jobsOrderable.setOrderColumnOrdering();
        jobsOrderColumn = jobsOrderable.getOrderColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (String)jobsOrderColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTableName());
        queuesOrderable.setOrderColumnOrdering();
        queuesOrderColumn = queuesOrderable.getOrderColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (String)queuesOrderColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTableName());
        jobsOrderColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"FOO", (String)jobsOrderColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTableName());
        queuesOrderColumn.setSpecifiedName("BAR");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"BAR", (String)queuesOrderColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTableName());
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_TABLE_PrintQueue", (String)jobsOrderColumn.getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_TABLE_PrintQueue", (String)queuesOrderColumn.getTableName());
        ((Entity)printQueuePersistentType.getMapping()).getTable().setSpecifiedName("OTHER_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)jobsOrderColumn.getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)queuesOrderColumn.getTableName());
        queuesMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)jobsOrderColumn.getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)queuesOrderColumn.getTableName());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType printQueuePersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        OrmSpecifiedPersistentAttribute jobsPersistentAttribute = printQueuePersistentType.addAttributeToXml(printQueuePersistentType.getAttributeNamed("jobs"), "manyToMany");
        OrmManyToManyMapping jobsMapping = (OrmManyToManyMapping)jobsPersistentAttribute.getMapping();
        OrmPersistentType printJobPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute queuesPersistentAttribute = printJobPersistentType.addAttributeToXml(printJobPersistentType.getAttributeNamed("queues"), "manyToMany");
        OrmManyToManyMapping queuesMapping = (OrmManyToManyMapping)queuesPersistentAttribute.getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        JavaManyToManyMapping javaJobsManyToManyMapping = (JavaManyToManyMapping)jobsPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaJobsManyToManyMapping.getOrderable()).setOrderColumnOrdering();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        jobsPersistentAttribute.removeFromXml();
        OrmPersistentAttribute jobsPersistentAttribute2 = printQueuePersistentType.getAttributeNamed("jobs");
        ManyToManyMapping virtualJobsMapping = (ManyToManyMapping)jobsPersistentAttribute2.getMapping();
        jobsOrderable = (Orderable2_0)virtualJobsMapping.getOrderable();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)jobsOrderable.isNoOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)jobsOrderable.getOrderColumn().getName());
        queuesPersistentAttribute.removeFromXml();
        OrmPersistentAttribute queuesPersistentAttribute2 = printJobPersistentType.getAttributeNamed("queues");
        ManyToManyMapping virtualQueuesMapping = (ManyToManyMapping)queuesPersistentAttribute2.getMapping();
        queuesOrderable = (Orderable2_0)virtualQueuesMapping.getOrderable();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)queuesOrderable.isNoOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
        ((Orderable2_0)javaJobsManyToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"FOO", (String)jobsOrderable.getOrderColumn().getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
        JavaManyToManyMapping javaQueuesManyToManyMapping = (JavaManyToManyMapping)queuesPersistentAttribute2.getJavaPersistentAttribute().getMapping();
        javaQueuesManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JOIN_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"JOIN_TABLE", (String)jobsOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"FOO", (String)jobsOrderable.getOrderColumn().getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"JOIN_TABLE", (String)queuesOrderable.getOrderColumn().getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany(mappedBy=\"queues\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<test.PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<test.PrintQueue> queues;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping2_0 addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn virtualColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)virtualColumn.getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (String)virtualColumn.getColumnDefinition());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isInsertable());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isUpdatable());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isNullable());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualColumn.isUnique());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)255, (int)virtualColumn.getLength());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)virtualColumn.getScale());
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaManyToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"FOO", (String)virtualColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getSpecifiedTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedNullable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualColumn.getSpecifiedUnique());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)45, (Object)virtualColumn.getSpecifiedLength());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)46, (Object)virtualColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)47, (Object)virtualColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        OneToManyMapping2_0 addressesMapping = (OneToManyMapping2_0)addressesPersistentAttribute.getMapping();
        virtualColumn = addressesMapping.getMapKeyColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"oneToMany", (String)addressesPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)virtualColumn.getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)virtualColumn.getTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (String)virtualColumn.getColumnDefinition());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isInsertable());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isUpdatable());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualColumn.isNullable());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)virtualColumn.isUnique());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)255, (int)virtualColumn.getLength());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)virtualColumn.getScale());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmSpecifiedPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        OrmCollectionMapping2_0 addressesVirtualMapping = (OrmCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaManyToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping2_0 addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getTableName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getTableName());
        ManyToManyMapping2_0 javaManyToManyMapping = (ManyToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormColumn.getTableName());
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("JAVA_TABLE");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getTableName());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"ORM_TABLE_Address", (String)ormColumn.getDefaultTableName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"address", (String)virtualManyToManyMapping.getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)virtualManyToManyMapping.getSpecifiedFetch());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"Address", (String)virtualManyToManyMapping.getSpecifiedTargetEntity());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)virtualManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)virtualManyToManyMapping.getCascade();
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)cascade.isDetach());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualManyToManyMapping.getOrderable().isOrderByOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"city", (String)virtualManyToManyMapping.getOrderable().getOrderBy().getKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualManyToManyMapping).getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"oneToMany", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("manyToMany");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLinkOrmManyToManyMapping ormManyToManyMapping = (EclipseLinkOrmManyToManyMapping)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"address", (String)ormManyToManyMapping.getName());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getFetch());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((String)"test.Address", (String)ormManyToManyMapping.getTargetEntity());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmCascade2_0 cascade = ormManyToManyMapping.getCascade();
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLink2_0OrmManyToManyMappingTests.assertFalse((boolean)cascade.isDetach());
        EclipseLink2_0OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (String)ormManyToManyMapping.getOrderable().getOrderBy().getKey());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals(null, (Object)ormManyToManyMapping.getJoinFetch().getValue());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(EnumType.ORDINAL);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(EnumType.STRING);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        ormManyToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)manyToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.STRING);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)manyToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ormManyToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
    }

    public void testUpdateSpecifiedTemporal() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.DATE);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)TemporalType.DATE, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.TIME);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.TIMESTAMP);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
    }

    public void testModifySpecifiedTemporal() throws Exception {
        this.createTestTypeWithCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToManyMapping"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        ormManyToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)TemporalType.DATE, (Object)manyToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        ((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)manyToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        ormManyToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        EclipseLink2_0OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
    }
}

