/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @Converter");
            }
        });
    }

    public EclipseLinkOrmConverterTests(String name) {
        super(name);
    }

    public void testUpdateConverterClass() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmCustomConverter ormConverter = ormBasicMapping.getConverterContainer().addCustomConverter("customConverter", 0);
        XmlConverter converterResource = (XmlConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverters().get(0);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
        converterResource.setClassName("myConvert");
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)converterResource.getClassName());
        converterResource.setClassName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
    }

    public void testModifyConverterClass() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmCustomConverter ormConverter = ormBasicMapping.getConverterContainer().addCustomConverter("customConverter", 0);
        XmlConverter converterResource = (XmlConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverters().get(0);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
        ormConverter.setConverterClass("foo");
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)converterResource.getClassName());
        ormConverter.setConverterClass(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getClassName());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmCustomConverter ormConverter = ormBasicMapping.getConverterContainer().addCustomConverter("customConverter", 0);
        XmlConverter converterResource = (XmlConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverters().get(0);
        EclipseLinkOrmConverterTests.assertEquals((String)"customConverter", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"customConverter", (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmCustomConverter ormConverter = ormBasicMapping.getConverterContainer().addCustomConverter("customConverter", 0);
        XmlConverter converterResource = (XmlConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getConverters().get(0);
        EclipseLinkOrmConverterTests.assertEquals((String)"customConverter", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"customConverter", (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

