/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TenantDiscriminatorColumnAnnotation2_3;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLink2_3JavaResourceModelTestCase;

public class EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests
extends EclipseLink2_3JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_CONTEXT_PROPERTY = "eclipselink.foo-id";
    private static final String COLUMN_TABLE = "MY_TABLE";

    public EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTenantDiscriminatorColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn");
            }
        });
    }

    private ICompilationUnit createTestTenantDiscriminatorColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestTenantDiscriminatorColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestTenantDiscriminatorColumnWithContextProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(contextProperty = \"eclipselink.foo-id\")");
            }
        });
    }

    private ICompilationUnit createTestTenantDiscriminatorColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestTenenatDiscriminatorColumnWithDiscriminatorType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn", "javax.persistence.DiscriminatorType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(discriminatorType = DiscriminatorType.CHAR)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithIntElement(final String intElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(" + intElement + " = 5)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@TenantDiscriminatorColumn(" + booleanElement + " = true)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getName());
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getDiscriminatorType());
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getName());
        column.setName("Foo");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@TenantDiscriminatorColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("(name", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@TenantDiscriminatorColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("(columnDefinition", cu);
    }

    public void testGetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("length");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)5, (Object)column.getLength());
    }

    public void testSetLength() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getLength());
        column.setLength(Integer.valueOf(5));
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)5, (Object)column.getLength());
        this.assertSourceContains("@TenantDiscriminatorColumn(length = 5)", cu);
        column.setLength(null);
        this.assertSourceDoesNotContain("(length", cu);
    }

    public void testGetDiscriminatorType() throws Exception {
        ICompilationUnit cu = this.createTestTenenatDiscriminatorColumnWithDiscriminatorType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)DiscriminatorType.CHAR, (Object)column.getDiscriminatorType());
    }

    public void testSetDiscriminatorType() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getDiscriminatorType());
        column.setDiscriminatorType(DiscriminatorType.INTEGER);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)DiscriminatorType.INTEGER, (Object)column.getDiscriminatorType());
        this.assertSourceContains("@TenantDiscriminatorColumn(discriminatorType = INTEGER)", cu);
        column.setDiscriminatorType(null);
        this.assertSourceDoesNotContain("(discriminatorType", cu);
    }

    public void testGetContextProperty() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumnWithContextProperty();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)COLUMN_CONTEXT_PROPERTY, (String)column.getContextProperty());
    }

    public void testSetContextProperty() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getContextProperty());
        column.setContextProperty("Foo");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)"Foo", (String)column.getContextProperty());
        this.assertSourceContains("@TenantDiscriminatorColumn(contextProperty = \"Foo\")", cu);
        column.setContextProperty(null);
        this.assertSourceDoesNotContain("(contextProperty", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumnWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@TenantDiscriminatorColumn(table = \"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("(table", cu);
    }

    public void testGetPrimaryKey() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithBooleanElement("primaryKey");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)Boolean.TRUE, (Object)column.getPrimaryKey());
    }

    public void testSetPrimaryKey() throws Exception {
        ICompilationUnit cu = this.createTestTenantDiscriminatorColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        TenantDiscriminatorColumnAnnotation2_3 column = (TenantDiscriminatorColumnAnnotation2_3)resourceType.getAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNotNull((Object)column);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertNull((Object)column.getPrimaryKey());
        column.setPrimaryKey(Boolean.FALSE);
        EclipseLinkTenantDiscriminatorColumnAnnotation2_3Tests.assertEquals((Object)Boolean.FALSE, (Object)column.getPrimaryKey());
        this.assertSourceContains("@TenantDiscriminatorColumn(primaryKey = false)", cu);
        column.setPrimaryKey(null);
        this.assertSourceDoesNotContain("primaryKey", cu);
    }
}

