/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MapKeyConvertAnnotation2_0;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLink2_0JavaResourceModelTestCase;

public class MapKeyConvertAnnotation2_0Tests
extends EclipseLink2_0JavaResourceModelTestCase {
    public MapKeyConvertAnnotation2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKeyConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.MapKeyConvert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyConvert");
            }
        });
    }

    private ICompilationUnit createTestConverterWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.MapKeyConvert"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyConvert(value=\"myConverter\")");
            }
        });
    }

    public void testMapKeyConvertAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyConvert();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyConvertAnnotation2_0Tests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert"));
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.MapKeyConvert");
        MapKeyConvertAnnotation2_0Tests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert"));
        resourceField.addAnnotation("org.eclipse.persistence.annotations.MapKeyConvert");
        MapKeyConvertAnnotation2_0Tests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyConvertAnnotation2_0 convert = (MapKeyConvertAnnotation2_0)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert");
        MapKeyConvertAnnotation2_0Tests.assertEquals((String)"myConverter", (String)convert.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyConvertAnnotation2_0 convert = (MapKeyConvertAnnotation2_0)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert");
        MapKeyConvertAnnotation2_0Tests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue("Bar");
        MapKeyConvertAnnotation2_0Tests.assertEquals((String)"Bar", (String)convert.getValue());
        this.assertSourceContains("@MapKeyConvert(value=\"Bar\")", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestConverterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyConvertAnnotation2_0 convert = (MapKeyConvertAnnotation2_0)resourceField.getAnnotation("org.eclipse.persistence.annotations.MapKeyConvert");
        MapKeyConvertAnnotation2_0Tests.assertEquals((String)"myConverter", (String)convert.getValue());
        convert.setValue(null);
        MapKeyConvertAnnotation2_0Tests.assertNull((Object)convert.getValue());
        this.assertSourceContains("@MapKeyConvert", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

