/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ObjectTypeConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ObjectTypeConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestObjectTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithDataType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(dataType=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithObjectType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(objectType=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(name = \"bar\")");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithDefaultObjectValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(defaultObjectValue = \"f\")");
            }
        });
    }

    private ICompilationUnit createTestObjectTypeConverterWithConversionValues() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})");
            }
        });
    }

    public void testObjectTypeConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("org.eclipse.persistence.annotations.ObjectTypeConverter"));
        resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter"));
    }

    public void testGetDataType() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getDataType());
        this.assertSourceContains("@ObjectTypeConverter(dataType=Bar.class)", cu);
        converter.setDataType("int");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"int", (String)converter.getDataType());
        this.assertSourceContains("@ObjectTypeConverter(dataType=int.class)", cu);
    }

    public void testSetDataTypeNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType(null);
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.getDataType());
        this.assertSourceContains("@ObjectTypeConverter", cu);
        this.assertSourceDoesNotContain("dataType", cu);
    }

    public void testGetObjectType() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        this.assertSourceContains("@ObjectTypeConverter(objectType=Bar.class)", cu);
        converter.setObjectType("int");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"int", (String)converter.getObjectType());
        this.assertSourceContains("@ObjectTypeConverter(objectType=int.class)", cu);
    }

    public void testSetObjectTypeNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType(null);
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.getObjectType());
        this.assertSourceContains("@ObjectTypeConverter", cu);
        this.assertSourceDoesNotContain("objectType", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@ObjectTypeConverter(name = \"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@ObjectTypeConverter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }

    public void testGetDefaultObjectValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDefaultObjectValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"f", (String)converter.getDefaultObjectValue());
    }

    public void testSetDefaultObjectValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDefaultObjectValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"f", (String)converter.getDefaultObjectValue());
        converter.setDefaultObjectValue("foo");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getDefaultObjectValue());
        this.assertSourceContains("@ObjectTypeConverter(defaultObjectValue = \"foo\")", cu);
    }

    public void testSetDefaultObjectValueNull() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithDefaultObjectValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"f", (String)converter.getDefaultObjectValue());
        converter.setDefaultObjectValue(null);
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.getDefaultObjectValue());
        this.assertSourceContains("@ObjectTypeConverter", cu);
        this.assertSourceDoesNotContain("defaultObjectValue", cu);
    }

    public void testConversionValues() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((int)0, (int)converter.getConversionValuesSize());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)converter.getConversionValues().iterator().hasNext());
    }

    public void testConversionValues2() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0);
        converter.addConversionValue(1);
        ObjectTypeConverterAnnotationTests.assertEquals((int)2, (int)converter.getConversionValuesSize());
        ListIterator conversionValues = converter.getConversionValues().iterator();
        ObjectTypeConverterAnnotationTests.assertTrue((boolean)conversionValues.hasNext());
        ObjectTypeConverterAnnotationTests.assertNotNull(conversionValues.next());
        ObjectTypeConverterAnnotationTests.assertNotNull(conversionValues.next());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)conversionValues.hasNext());
    }

    public void testConversionValues3() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        ObjectTypeConverterAnnotationTests.assertEquals((int)2, (int)converter.getConversionValuesSize());
        ListIterator conversionValues = converter.getConversionValues().iterator();
        ConversionValueAnnotation conversionValue = (ConversionValueAnnotation)conversionValues.next();
        ObjectTypeConverterAnnotationTests.assertEquals((String)"F", (String)conversionValue.getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Female", (String)conversionValue.getObjectValue());
        conversionValue = (ConversionValueAnnotation)conversionValues.next();
        ObjectTypeConverterAnnotationTests.assertEquals((String)"M", (String)conversionValue.getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)conversionValue.getObjectValue());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)conversionValues.hasNext());
    }

    public void testAddConversionValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setObjectValue("FOO");
        converter.addConversionValue(1);
        converter.addConversionValue(0).setDataValue("BAR");
        ObjectTypeConverterAnnotationTests.assertEquals((String)"BAR", (String)converter.conversionValueAt(0).getDataValue());
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.conversionValueAt(0).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"FOO", (String)converter.conversionValueAt(1).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.conversionValueAt(1).getDataValue());
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.conversionValueAt(2).getDataValue());
        ObjectTypeConverterAnnotationTests.assertNull((Object)converter.conversionValueAt(2).getObjectValue());
        this.assertSourceContains("@ObjectTypeConverter(name = \"bar\", conversionValues = {@ConversionValue(dataValue = \"BAR\"),@ConversionValue(objectValue = \"FOO\"), @ConversionValue})", cu);
    }

    public void testRemoveConversionValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setObjectValue("FOO");
        ListIterator conversionValues = converter.getConversionValues().iterator();
        ObjectTypeConverterAnnotationTests.assertEquals((String)"FOO", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Female", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)conversionValues.hasNext());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(objectValue = \"FOO\"), @ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
        converter.removeConversionValue(1);
        conversionValues = converter.getConversionValues().iterator();
        ObjectTypeConverterAnnotationTests.assertEquals((String)"FOO", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)conversionValues.hasNext());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(objectValue = \"FOO\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
        converter.removeConversionValue(0);
        conversionValues = converter.getConversionValues().iterator();
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)((ConversionValueAnnotation)conversionValues.next()).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertFalse((boolean)conversionValues.hasNext());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = @ConversionValue(dataValue = \"M\", objectValue = \"Male\"))", cu);
        converter.removeConversionValue(0);
        this.assertSourceDoesNotContain("@conversionValues", cu);
        this.assertSourceContains("@ObjectTypeConverter", cu);
    }

    public void testMoveConversionValue() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setObjectValue("FOO");
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(objectValue = \"FOO\"), @ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
        converter.moveConversionValue(2, 0);
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Female", (String)converter.conversionValueAt(0).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"F", (String)converter.conversionValueAt(0).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)converter.conversionValueAt(1).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"M", (String)converter.conversionValueAt(1).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"FOO", (String)converter.conversionValueAt(2).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals(null, (String)converter.conversionValueAt(2).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((int)3, (int)converter.getConversionValuesSize());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\"), @ConversionValue(objectValue = \"FOO\")})", cu);
    }

    public void testMoveConversionValue2() throws Exception {
        ICompilationUnit cu = this.createTestObjectTypeConverterWithConversionValues();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ObjectTypeConverterAnnotation converter = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setObjectValue("FOO");
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(objectValue = \"FOO\"), @ConversionValue(dataValue = \"F\", objectValue = \"Female\"), @ConversionValue(dataValue = \"M\", objectValue = \"Male\")})", cu);
        converter.moveConversionValue(0, 2);
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Male", (String)converter.conversionValueAt(0).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"M", (String)converter.conversionValueAt(0).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"FOO", (String)converter.conversionValueAt(1).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals(null, (String)converter.conversionValueAt(1).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"Female", (String)converter.conversionValueAt(2).getObjectValue());
        ObjectTypeConverterAnnotationTests.assertEquals((String)"F", (String)converter.conversionValueAt(2).getDataValue());
        ObjectTypeConverterAnnotationTests.assertEquals((int)3, (int)converter.getConversionValuesSize());
        this.assertSourceContains("@ObjectTypeConverter(conversionValues = {@ConversionValue(dataValue = \"M\", objectValue = \"Male\"), @ConversionValue(objectValue = \"FOO\"), @ConversionValue(dataValue = \"F\", objectValue = \"Female\")})", cu);
    }
}

