/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ReadTransformerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ReadTransformerAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public ReadTransformerAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestReadTransformer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer");
            }
        });
    }

    private ICompilationUnit createTestReadTransformerWithTransformerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer(transformerClass=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestReadTransformerWithMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ReadTransformer"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ReadTransformer(method=\"transformerMethod\")");
            }
        });
    }

    public void testReadTransformerAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformer();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
        resourceField.addAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer"));
    }

    public void testGetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
    }

    public void testSetTransformerClass() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
        readTransformer.setTransformerClass("Bar");
        ReadTransformerAnnotationTests.assertEquals((String)"Bar", (String)readTransformer.getTransformerClass());
        this.assertSourceContains("@ReadTransformer(transformerClass=Bar.class)", cu);
    }

    public void testSetTransformerClassNull() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithTransformerClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"Foo", (String)readTransformer.getTransformerClass());
        readTransformer.setTransformerClass(null);
        ReadTransformerAnnotationTests.assertNull((Object)readTransformer.getTransformerClass());
        this.assertSourceContains("@ReadTransformer", cu);
        this.assertSourceDoesNotContain("transformerClass", cu);
    }

    public void testGetMethod() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
    }

    public void testSetMethod() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
        readTransformer.setMethod("foo");
        ReadTransformerAnnotationTests.assertEquals((String)"foo", (String)readTransformer.getMethod());
        this.assertSourceContains("@ReadTransformer(method=\"foo\")", cu);
    }

    public void testSetMethodNull() throws Exception {
        ICompilationUnit cu = this.createTestReadTransformerWithMethod();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        ReadTransformerAnnotation readTransformer = (ReadTransformerAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.ReadTransformer");
        ReadTransformerAnnotationTests.assertEquals((String)"transformerMethod", (String)readTransformer.getMethod());
        readTransformer.setMethod(null);
        ReadTransformerAnnotationTests.assertNull((Object)readTransformer.getMethod());
        this.assertSourceContains("@ReadTransformer", cu);
        this.assertSourceDoesNotContain("method", cu);
    }
}

