/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class GenericOrmPersistentAttributeTests
extends ContextModelTestCase {
    public GenericOrmPersistentAttributeTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertNull((Object)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute.addToXml("oneToOne");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmOneToOneMapping));
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ormPersistentAttribute.addToXml("id");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.getDefaultAttributes().iterator();
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).addToXml();
        ((OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getMapping().setName("noJavaAttribute");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmSpecifiedPersistentAttribute specifiedOrmPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.removeFromXml();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getDefaultAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next()).getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaSpecifiedPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        JavaResourceAttribute javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getFields().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentAttribute.addToXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmSpecifiedPersistentAttribute)ormPersistentAttribute).removeFromXml();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmPersistentAttribute idFieldAttribute = (OrmPersistentAttribute)attributes.next();
        OrmPersistentAttribute idPropertyAttribute = (OrmPersistentAttribute)attributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((Object)ormPersistentAttribute, (Object)idFieldAttribute);
        GenericOrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)idPropertyAttribute);
        ormPersistentAttribute = idPropertyAttribute;
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)idFieldAttribute.getJavaPersistentAttribute().getAccess());
        javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getMethods().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.addToXml();
        ormPersistentAttribute2.getMapping().setName("id2");
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }
}

