/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmColumnTests
extends ContextModelTestCase {
    public OrmColumnTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setName("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getName());
        basic.getColumn().setName(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn().getName());
        basic.getColumn().setName("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getName());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedName("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedName());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getName());
        ormColumn.setSpecifiedName(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateColumnDefinition() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setColumnDefinition("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getColumnDefinition());
        basic.getColumn().setColumnDefinition(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn().getColumnDefinition());
        basic.getColumn().setColumnDefinition("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getColumnDefinition());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifyColumnDefinition() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setColumnDefinition("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getColumnDefinition());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getColumnDefinition());
        ormColumn.setColumnDefinition(null);
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedTable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setTable("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getTable());
        basic.getColumn().setTable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)basic.getColumn().getTable());
        basic.getColumn().setTable("FOO");
        OrmColumnTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertEquals((String)"FOO", (String)basic.getColumn().getTable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedTable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedTableName("foo");
        OrmColumnTests.assertEquals((String)"foo", (String)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertEquals((String)"foo", (String)basic.getColumn().getTable());
        ormColumn.setSpecifiedTableName(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedNullable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setNullable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getNullable());
        basic.getColumn().setNullable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getNullable());
        basic.getColumn().setNullable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getNullable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedNullable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedNullable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getNullable());
        ormColumn.setSpecifiedNullable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedUpdatable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setUpdatable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getUpdatable());
        basic.getColumn().setUpdatable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getUpdatable());
        basic.getColumn().setUpdatable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUpdatable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedUpdatable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedUpdatable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUpdatable());
        ormColumn.setSpecifiedUpdatable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedInsertable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setInsertable(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getInsertable());
        basic.getColumn().setInsertable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn().getInsertable());
        basic.getColumn().setInsertable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getInsertable());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedInsertable() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedInsertable(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getInsertable());
        ormColumn.setSpecifiedInsertable(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedUnique() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setUnique(Boolean.TRUE);
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getColumn().getUnique());
        basic.getColumn().setUnique(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn().getUnique());
        basic.getColumn().setUnique(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUnique());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedUnique() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedUnique(Boolean.FALSE);
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getColumn().getUnique());
        ormColumn.setSpecifiedUnique(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedLength() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setLength(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getLength());
        basic.getColumn().setLength(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getLength());
        basic.getColumn().setLength(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getLength());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedLength() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedLength(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getLength());
        ormColumn.setSpecifiedLength(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedPrecision() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setPrecision(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getPrecision());
        basic.getColumn().setPrecision(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getPrecision());
        basic.getColumn().setPrecision(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getPrecision());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedPrecision() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedPrecision(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getPrecision());
        ormColumn.setSpecifiedPrecision(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testUpdateSpecifiedScale() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        basic.setColumn(OrmFactory.eINSTANCE.createXmlColumn());
        basic.getColumn().setScale(Integer.valueOf(8));
        OrmColumnTests.assertEquals((Object)8, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)8, (Object)basic.getColumn().getScale());
        basic.getColumn().setScale(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn().getScale());
        basic.getColumn().setScale(Integer.valueOf(11));
        OrmColumnTests.assertEquals((Object)11, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)11, (Object)basic.getColumn().getScale());
        basic.setColumn(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testModifySpecifiedScale() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = ormBasicMapping.getColumn();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entityResource.getAttributes().getBasics().get(0);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
        ormColumn.setSpecifiedScale(Integer.valueOf(7));
        OrmColumnTests.assertEquals((Object)7, (Object)ormColumn.getSpecifiedScale());
        OrmColumnTests.assertEquals((Object)7, (Object)basic.getColumn().getScale());
        ormColumn.setSpecifiedScale(null);
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)basic.getColumn());
    }

    public void testVirtualColumnDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ListIterator attributes = ormPersistentType.getDefaultAttributes().iterator();
        attributes.next();
        OrmPersistentAttribute namePersistentAttribute = (OrmPersistentAttribute)attributes.next();
        BasicMapping nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        SpecifiedColumn virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"name", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)virtualColumn.getTableName());
        OrmColumnTests.assertNull((Object)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)255, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getScale());
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        JavaSpecifiedColumn javaColumn = javaBasicMapping.getColumn();
        javaColumn.setSpecifiedName("FOO");
        javaColumn.setSpecifiedTableName("FOO_TABLE");
        javaColumn.setColumnDefinition("COLUMN_DEFINITION");
        javaColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaColumn.setSpecifiedNullable(Boolean.FALSE);
        javaColumn.setSpecifiedUnique(Boolean.TRUE);
        javaColumn.setSpecifiedLength(Integer.valueOf(45));
        javaColumn.setSpecifiedPrecision(Integer.valueOf(46));
        javaColumn.setSpecifiedScale(Integer.valueOf(47));
        this.getJpaProject().synchronizeContextModel();
        nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"FOO", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getTableName());
        OrmColumnTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)45, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)46, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)47, (int)virtualColumn.getScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"name", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)virtualColumn.getTableName());
        OrmColumnTests.assertNull((Object)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)255, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getScale());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"name", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)virtualColumn.getTableName());
        OrmColumnTests.assertNull((Object)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)255, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(null);
        nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"name", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)virtualColumn.getTableName());
        OrmColumnTests.assertNull((Object)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)255, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)0, (int)virtualColumn.getScale());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        nameVirtualMapping = (BasicMapping)namePersistentAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"FOO", (String)virtualColumn.getName());
        OrmColumnTests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getTableName());
        OrmColumnTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isInsertable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isUpdatable());
        OrmColumnTests.assertFalse((boolean)virtualColumn.isNullable());
        OrmColumnTests.assertTrue((boolean)virtualColumn.isUnique());
        OrmColumnTests.assertEquals((int)45, (int)virtualColumn.getLength());
        OrmColumnTests.assertEquals((int)46, (int)virtualColumn.getPrecision());
        OrmColumnTests.assertEquals((int)47, (int)virtualColumn.getScale());
    }

    public void testNullColumnDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute namePersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("name"), "basic");
        OrmBasicMapping nameVirtualMapping = (OrmBasicMapping)namePersistentAttribute.getMapping();
        OrmSpecifiedColumn ormColumn = nameVirtualMapping.getColumn();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        JavaSpecifiedColumn javaColumn = javaBasicMapping.getColumn();
        javaColumn.setSpecifiedName("FOO");
        javaColumn.setSpecifiedTableName("FOO_TABLE");
        javaColumn.setColumnDefinition("COLUMN_DEFINITION");
        javaColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaColumn.setSpecifiedNullable(Boolean.FALSE);
        javaColumn.setSpecifiedUnique(Boolean.TRUE);
        javaColumn.setSpecifiedLength(Integer.valueOf(45));
        javaColumn.setSpecifiedPrecision(Integer.valueOf(46));
        javaColumn.setSpecifiedScale(Integer.valueOf(47));
        OrmColumnTests.assertEquals((String)"name", (String)ormColumn.getDefaultName());
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTableName());
        OrmColumnTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmColumnTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmColumnTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmColumnTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmColumnTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmColumnTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmColumnTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedTableName());
        OrmColumnTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmColumnTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualColumnTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute nameOrmAttribute = ormPersistentType.getAttributeNamed("name");
        BasicMapping nameVirtualMapping = (BasicMapping)nameOrmAttribute.getMapping();
        SpecifiedColumn virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"AnnotationTestType", (String)virtualColumn.getTableName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        OrmColumnTests.assertEquals((String)"ORM_TABLE", (String)virtualColumn.getTableName());
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedTableName("JAVA_TABLE");
        nameVirtualMapping = (BasicMapping)nameOrmAttribute.getMapping();
        virtualColumn = nameVirtualMapping.getColumn();
        OrmColumnTests.assertEquals((String)"JAVA_TABLE", (String)virtualColumn.getTableName());
        nameOrmAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("name"), "basic");
        OrmBasicMapping nameSpecifiedMapping = (OrmBasicMapping)nameOrmAttribute.getMapping();
        SpecifiedColumn specifiedColumn = nameSpecifiedMapping.getColumn();
        OrmColumnTests.assertNull((Object)specifiedColumn.getSpecifiedTableName());
        OrmColumnTests.assertEquals((String)"ORM_TABLE", (String)specifiedColumn.getDefaultTableName());
        OrmColumnTests.assertEquals((String)"ORM_TABLE", (String)specifiedColumn.getTableName());
    }
}

