/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsIdAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapsId2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public MapsId2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapsId() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapsId"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapsId");
            }
        });
    }

    private ICompilationUnit createTestMapsIdWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapsId"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapsId(\"foo\")");
            }
        });
    }

    public void testMapsId() throws Exception {
        ICompilationUnit cu = this.createTestMapsId();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        MapsId2_0AnnotationTests.assertNotNull((Object)annotation);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapsIdWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        MapsId2_0AnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapsId();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.assertSourceContains("@MapsId(\"foo\")", cu);
        annotation.setValue(null);
        this.assertSourceContains("@MapsId", cu);
    }
}

