/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGeneratorAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class SequenceGenerator2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String GENERATOR_CATALOG = "TEST_CATALOG";
    private static final String GENERATOR_SCHEMA = "TEST_SCHEMA";

    public SequenceGenerator2_0AnnotationTests(String name) {
        super(name);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SequenceGeneratorAnnotation2_0 sequenceGenerator = (SequenceGeneratorAnnotation2_0)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_CATALOG, (String)sequenceGenerator.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithCatalog();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SequenceGeneratorAnnotation2_0 sequenceGenerator = (SequenceGeneratorAnnotation2_0)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_CATALOG, (String)sequenceGenerator.getCatalog());
        sequenceGenerator.setCatalog("foo");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)"foo", (String)sequenceGenerator.getCatalog());
        this.assertSourceContains("@SequenceGenerator(catalog = \"foo\")", cu);
        sequenceGenerator.setCatalog(null);
        SequenceGenerator2_0AnnotationTests.assertNull((Object)sequenceGenerator.getCatalog());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SequenceGeneratorAnnotation2_0 sequenceGenerator = (SequenceGeneratorAnnotation2_0)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_SCHEMA, (String)sequenceGenerator.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSchema();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SequenceGeneratorAnnotation2_0 sequenceGenerator = (SequenceGeneratorAnnotation2_0)resourceField.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_SCHEMA, (String)sequenceGenerator.getSchema());
        sequenceGenerator.setSchema("foo");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)"foo", (String)sequenceGenerator.getSchema());
        this.assertSourceContains("@SequenceGenerator(schema = \"foo\")", cu);
        sequenceGenerator.setSchema(null);
        SequenceGenerator2_0AnnotationTests.assertNull((Object)sequenceGenerator.getSchema());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    protected ICompilationUnit createTestSequenceGeneratorWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestSequenceGeneratorWithCatalog() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("catalog", GENERATOR_CATALOG);
    }

    private ICompilationUnit createTestSequenceGeneratorWithSchema() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("schema", GENERATOR_SCHEMA);
    }
}

