/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class EntityTests
extends JpaJavaResourceModelTestCase {
    private static final String ENTITY_NAME = "Foo";

    public EntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity(name = \"Foo\")");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassAndEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
                sb.append("@Entity");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EntityTests.assertTrue((entity != null ? 1 : 0) != 0);
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
    }

    public void testGetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EntityTests.assertTrue((entity != null ? 1 : 0) != 0);
        EntityTests.assertNull((Object)entity.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EntityTests.assertNull((Object)entity.getName());
        entity.setName(ENTITY_NAME);
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
        this.assertSourceContains("@Entity(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestEntityWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EntityTests.assertEquals((String)ENTITY_NAME, (String)entity.getName());
        entity.setName(null);
        EntityTests.assertNull((Object)entity.getName());
        this.assertSourceContains("@Entity", cu);
        this.assertSourceDoesNotContain("@Entity(name = \"Foo\")", cu);
    }

    public void testMappedSuperclassAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclassAndEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        EntityAnnotation mappingAnnotation = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EntityTests.assertNotNull((Object)mappingAnnotation);
        MappedSuperclassAnnotation mappedSuperclass = (MappedSuperclassAnnotation)resourceType.getAnnotation("javax.persistence.MappedSuperclass");
        EntityTests.assertNotNull((Object)mappedSuperclass);
    }
}

