/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class MapKeyTests
extends JpaJavaResourceModelTestCase {
    public MapKeyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKey() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey");
            }
        });
    }

    private ICompilationUnit createTestMapKeyWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey(name = \"key\")");
            }
        });
    }

    public void testMapKey() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertNotNull((Object)mapKey);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertEquals((String)"key", (String)mapKey.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        mapKey.setName("foo");
        this.assertSourceContains("@MapKey(name = \"foo\")", cu);
        mapKey.setName(null);
        this.assertSourceContains("@MapKey", cu);
        this.assertSourceDoesNotContain("@MapKey(name = \"foo\")", cu);
    }
}

