/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class TemporalTests
extends JpaJavaResourceModelTestCase {
    public TemporalTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Temporal"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal");
            }
        });
    }

    private ICompilationUnit createTestTemporalWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal(TemporalType.DATE)");
            }
        });
    }

    public void testTemporal() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        TemporalTests.assertNotNull((Object)temporal);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporalWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        TemporalTests.assertEquals((Object)TemporalType.DATE, (Object)temporal.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.TIME);
        this.assertSourceContains("@Temporal(TIME)", cu);
        temporal.setValue(null);
        this.assertSourceDoesNotContain("@Temporal(", cu);
    }
}

