/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericContextRootTests
extends JaxbContextModelTestCase {
    public GenericContextRootTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorOrder() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)", new String[]{"javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
    }

    private ICompilationUnit createClassWithXmlTypeAndSuperclassNamed(final String superclassName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends " + superclassName);
            }
        });
    }

    private ICompilationUnit createClassWithXmlTypeAndAttribute(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public " + typeName + " " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createClassWithXmlTypeAndListAttribute(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"java.util.List", "javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public List<" + typeName + "> " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    public void testGetPackages() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        Iterator packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        this.createUnannotatedPackageInfo("foo");
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        JavaResourcePackage fooResourcePackage = this.getJaxbProject().getJavaResourcePackage("foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlAccessorTypeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
            }
        });
        Iterable packageNames = IterableTools.transform((Iterable)this.getContextRoot().getPackages(), (Transformer)JaxbPackage.NAME_TRANSFORMER);
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertTrue((boolean)IterableTools.contains((Iterable)packageNames, (Object)"test"));
        GenericContextRootTests.assertTrue((boolean)IterableTools.contains((Iterable)packageNames, (Object)"foo"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeXmlAccessorTypeAnnotation(declaration);
            }
        });
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
    }

    protected void addXmlAccessorTypeAnnotation(ModifiedDeclaration declaration, String accessType) {
        NormalAnnotation annotation = this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorType");
        this.addEnumMemberValuePair(annotation, "value", accessType);
    }

    protected void removeXmlAccessorTypeAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
    }

    protected void addXmlSeeAlsoAnnotation(ModifiedDeclaration declaration, String ... typeNames) {
        Annotation annotation = declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSeeAlso");
        NormalAnnotation normalAnnotation = null;
        normalAnnotation = annotation == null ? this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSeeAlso") : (annotation.isMarkerAnnotation() ? this.replaceMarkerAnnotation((MarkerAnnotation)annotation) : (NormalAnnotation)annotation);
        ArrayInitializer arrayInitializer = this.newArrayInitializer(declaration.getAst(), (Expression[])ArrayTools.array((Iterable)IterableTools.transform((Iterable)IterableTools.iterable((Object[])typeNames), (Transformer)new AnnotationTestCase.StringTypeLiteralTransformer((AnnotationTestCase)this, declaration.getAst())), (Object[])new Expression[0]));
        this.addMemberValuePair(normalAnnotation, "value", (Expression)arrayInitializer);
    }

    public void testGetRegistries() throws Exception {
        this.createClassWithXmlRegistry();
        Iterable types = this.getContextRoot().getJavaTypes();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType")).getXmlRegistry());
        this.createUnannotatedClassNamed("Foo");
        types = this.getContextRoot().getJavaTypes();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType")).getXmlRegistry());
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        types = this.getContextRoot().getJavaTypes();
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JavaClass)this.getContextRoot().getJavaType("test.Foo")).getXmlRegistry());
        GenericContextRootTests.assertNotNull((Object)((JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType")).getXmlRegistry());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        types = this.getContextRoot().getJavaTypes();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)types));
        GenericContextRootTests.assertNotNull((Object)((JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType")).getXmlRegistry());
    }

    public void testGetTypes() throws Exception {
        this.createClassWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        this.createUnannotatedClassNamed("Foo");
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.Foo"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType("test.Foo"));
    }

    public void testGetTypes2() throws Exception {
        this.createEnumWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        this.createUnannotatedEnumNamed("Foo");
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType("test.Foo"));
        JavaResourceEnum fooResourceType = (JavaResourceEnum)this.getJaxbProject().getJavaResourceType("test.Foo", JavaResourceAnnotatedElement.AstNodeType.ENUM);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.Foo"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType("test.Foo"));
    }

    public void testDirectReferencedSuperclass() throws Exception {
        String superclassName = "SuperAnnotationTestType";
        String fqSuperclassName = "test." + superclassName;
        this.createUnannotatedClassNamed(superclassName);
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        this.createClassWithXmlTypeAndSuperclassNamed(superclassName);
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType(fqSuperclassName));
        IFile file = (IFile)this.getContextRoot().getJavaType("test.AnnotationTestType").getResource();
        file.delete(true, null);
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType(fqSuperclassName));
    }

    public void testDirectReferencedAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        this.createClassWithXmlTypeAndAttribute(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
    }

    public void testDirectReferencedListAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        this.createClassWithXmlTypeAndListAttribute(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getJavaType(fqOtherClassName));
    }

    public void testDirectReferencedSeeAlso() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        this.createClassWithXmlType();
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        AnnotatedElement annotatedType = this.annotatedElement((JavaResourceAnnotatedElement)thisType);
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType", "OtherAnnotationTestType2");
            }
        });
        GenericContextRootTests.assertEquals((int)3, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType2"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
    }

    public void testJaxbIndex() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)this.getContextRoot().getJavaTypes()));
        this.createClassWithXmlType();
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        IFile jaxbIndex = this.getJavaProjectTestHarness().getProject().getFile((IPath)new Path("src/test/jaxb.index"));
        ByteArrayInputStream stream = new ByteArrayInputStream("OtherAnnotationTestType".getBytes());
        jaxbIndex.create((InputStream)stream, true, null);
        GenericContextRootTests.assertEquals((int)2, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(("OtherAnnotationTestType" + CR + "OtherAnnotationTestType2").getBytes()), true, false, null);
        GenericContextRootTests.assertEquals((int)3, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.OtherAnnotationTestType2"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
        GenericContextRootTests.assertEquals((int)1, (int)IterableTools.size((Iterable)this.getContextRoot().getJavaTypes()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getJavaType("test.AnnotationTestType"));
    }
}

