/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlElementsMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlElementsMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlElementsMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElements() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElements"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElements");
            }
        });
    }

    protected NormalAnnotation newXmlPathAnnotation(AST ast, String value) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "org.eclipse.persistence.oxm.annotations.XmlPath");
        this.addMemberValuePair(annotation, "value", value);
        return annotation;
    }

    protected void addXmlPath(ModifiedDeclaration declaration, int index, String value) {
        NormalAnnotation annotation = this.newXmlPathAnnotation(declaration.getAst(), value);
        this.addArrayElement(declaration, "org.eclipse.persistence.oxm.annotations.XmlPaths", index, "value", (Expression)annotation);
    }

    protected void moveXmlPath(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlPaths"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlPath(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlPaths"), "value", index);
    }

    public void testUpdateXmlElements() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass javaClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = javaClass.getMapping();
        ELJavaXmlElementsMapping mapping = (ELJavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlPaths = mapping.getXmlPaths();
        ELJavaXmlElementsMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlPaths));
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlPathsSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementsMappingTests.this.addXmlPath(declaration, 0, "foo");
                ELJavaXmlElementsMappingTests.this.addXmlPath(declaration, 1, "bar");
            }
        });
        xmlPaths = mapping.getXmlPaths();
        ELJavaXmlElementsMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)xmlPaths));
        ELJavaXmlElementsMappingTests.assertEquals((int)2, (int)mapping.getXmlPathsSize());
        ELJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((ELXmlPath)IterableTools.get((Iterable)xmlPaths, (int)0)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((ELXmlPath)IterableTools.get((Iterable)xmlPaths, (int)1)).getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementsMappingTests.this.moveXmlPath(declaration, 0, 1);
            }
        });
        xmlPaths = mapping.getXmlPaths();
        ELJavaXmlElementsMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)xmlPaths));
        ELJavaXmlElementsMappingTests.assertEquals((int)2, (int)mapping.getXmlPathsSize());
        ELJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((ELXmlPath)IterableTools.get((Iterable)xmlPaths, (int)0)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((ELXmlPath)IterableTools.get((Iterable)xmlPaths, (int)1)).getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlElementsMappingTests.this.removeXmlPath(declaration, 1);
                ELJavaXmlElementsMappingTests.this.removeXmlPath(declaration, 0);
            }
        });
        xmlPaths = mapping.getXmlPaths();
        ELJavaXmlElementsMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlPaths));
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlPathsSize());
    }

    public void testModifyXmlPaths() throws Exception {
        this.createTypeWithXmlElements();
        JavaClass javaClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = javaClass.getMapping();
        ELJavaXmlElementsMapping mapping = (ELJavaXmlElementsMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlPath"));
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlPathsSize());
        mapping.addXmlPath(0).setValue("foo");
        mapping.addXmlPath(1).setValue("baz");
        mapping.addXmlPath(1).setValue("bar");
        SubIterableWrapper xmlPathAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath"));
        ELJavaXmlElementsMappingTests.assertEquals((int)3, (int)IterableTools.size((Iterable)xmlPathAnnotations));
        ELJavaXmlElementsMappingTests.assertEquals((int)3, (int)mapping.getXmlPathsSize());
        ELJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)0)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)1)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"baz", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)2)).getValue());
        mapping.moveXmlPath(1, 2);
        xmlPathAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath"));
        ELJavaXmlElementsMappingTests.assertEquals((int)3, (int)IterableTools.size((Iterable)xmlPathAnnotations));
        ELJavaXmlElementsMappingTests.assertEquals((int)3, (int)mapping.getXmlPathsSize());
        ELJavaXmlElementsMappingTests.assertEquals((String)"foo", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)0)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"baz", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)1)).getValue());
        ELJavaXmlElementsMappingTests.assertEquals((String)"bar", (String)((XmlPathAnnotation)IterableTools.get((Iterable)xmlPathAnnotations, (int)2)).getValue());
        mapping.removeXmlPath(2);
        mapping.removeXmlPath(0);
        mapping.removeXmlPath(0);
        xmlPathAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath"));
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)xmlPathAnnotations));
        ELJavaXmlElementsMappingTests.assertEquals((int)0, (int)mapping.getXmlPathsSize());
    }
}

