/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlSchema;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlSchema;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.OxmFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm.OxmContextModelTestCase;

public class OxmXmlSchemaTests
extends OxmContextModelTestCase {
    public OxmXmlSchemaTests(String name) {
        super(name);
    }

    protected void addOxmFile() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings").append(CR);
        sb.append("    version=\"2.4\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    package-name=\"").append("test").append("\"").append(CR);
        sb.append("    />").append(CR);
        this.addOxmFile("oxm.xml", sb);
    }

    protected ICompilationUnit createPackageInfoWithXmlSchema() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema", new String[]{"javax.xml.bind.annotation.XmlSchema"});
    }

    public void testUpdateNamespace() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo packageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        this.addOxmFile();
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlSchema xmlSchema = oxmFile.getXmlBindings().getXmlSchema();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlSchemaTests.assertNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertNotNull((Object)xmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertNull((Object)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getDefaultNamespace());
        packageInfo.getXmlSchema().setSpecifiedNamespace("foo");
        OxmXmlSchemaTests.assertNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertNotNull((Object)xmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"foo", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertNull((Object)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"foo", (String)xmlSchema.getDefaultNamespace());
        EXmlSchema eXmlSchema = OxmFactory.eINSTANCE.createEXmlSchema();
        eXmlBindings.setXmlSchema(eXmlSchema);
        eXmlSchema.setNamespace("bar");
        oxmResource.save();
        OxmXmlSchemaTests.assertNotNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertNotNull((Object)xmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"bar", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertEquals((String)"bar", (String)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"foo", (String)xmlSchema.getDefaultNamespace());
        eXmlSchema.setNamespace(null);
        oxmResource.save();
        OxmXmlSchemaTests.assertNotNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertNotNull((Object)xmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"foo", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertNull((Object)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"foo", (String)xmlSchema.getDefaultNamespace());
    }

    public void testModifyNamespace() throws Exception {
        this.addOxmFile();
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlSchema xmlSchema = oxmFile.getXmlBindings().getXmlSchema();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        OxmXmlSchemaTests.assertNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertNotNull((Object)xmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertNull((Object)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getDefaultNamespace());
        xmlSchema.setSpecifiedNamespace("bar");
        oxmResource.save();
        EXmlSchema eXmlSchema = eXmlBindings.getXmlSchema();
        this.assertFileContentsContains("oxm.xml", "<xml-schema", true);
        this.assertFileContentsContains("oxm.xml", "namespace=\"bar\"", true);
        OxmXmlSchemaTests.assertNotNull((Object)eXmlSchema);
        OxmXmlSchemaTests.assertEquals((String)"bar", (String)eXmlSchema.getNamespace());
        OxmXmlSchemaTests.assertEquals((String)"bar", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertEquals((String)"bar", (String)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getDefaultNamespace());
        xmlSchema.setSpecifiedNamespace(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "namespace=", false);
        OxmXmlSchemaTests.assertNotNull((Object)eXmlBindings.getXmlSchema());
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getNamespace());
        OxmXmlSchemaTests.assertNull((Object)xmlSchema.getSpecifiedNamespace());
        OxmXmlSchemaTests.assertEquals((String)"", (String)xmlSchema.getDefaultNamespace());
    }
}

