/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ActionListenerType;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.LocaleConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationHandlerType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.StateManagerType;
import org.eclipse.jst.jsf.facesconfig.emf.SupportedLocaleType;
import org.eclipse.jst.jsf.facesconfig.emf.VariableResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadApplicationTestCase
extends BaseReadTestCase {
    public ReadApplicationTestCase(String name) {
        super(name);
    }

    public void testSingleApplication() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getActionListener().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getDefaultRenderKitId().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getLocaleConfig().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getMessageBundle().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getNavigationHandler().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getPropertyResolver().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getStateManager().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getVariableResolver().size());
            ReadApplicationTestCase.assertEquals((int)1, (int)application1.getViewHandler().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    ApplicationType getApplication1(FacesConfigArtifactEdit edit) {
        ApplicationType application1 = FacesConfigModelUtil.findApplicationById((List)edit.getFacesConfig().getApplication(), "application1");
        ReadApplicationTestCase.assertNotNull((Object)application1);
        return application1;
    }

    public void testActionListener() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ActionListenerType actionListener = FacesConfigModelUtil.findActionListenerById((List)application1.getActionListener(), "actionListener1");
            ReadApplicationTestCase.assertNotNull((Object)actionListener);
            ReadApplicationTestCase.assertEquals((String)"Action listener", (String)actionListener.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultRenderKitId() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            DefaultRenderKitIdType defaultRenderKit = FacesConfigModelUtil.findDefaultRenderKitIdTypeById((List)application1.getDefaultRenderKitId(), "defaultRenderKit1");
            ReadApplicationTestCase.assertNotNull((Object)defaultRenderKit);
            ReadApplicationTestCase.assertEquals((String)"some renderer kit", (String)defaultRenderKit.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testMessageBundle() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            MessageBundleType messageBundleType = FacesConfigModelUtil.findMessageBundleTypeById((List)application1.getMessageBundle(), "messageBundle1");
            ReadApplicationTestCase.assertNotNull((Object)messageBundleType);
            ReadApplicationTestCase.assertEquals((String)"some messeage bundle goes here", (String)messageBundleType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNavigationHandler() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            NavigationHandlerType navigationHandlerType = (NavigationHandlerType)FacesConfigModelUtil.findEObjectElementById((List)application1.getNavigationHandler(), "navigationHandler1");
            ReadApplicationTestCase.assertNotNull((Object)navigationHandlerType);
            ReadApplicationTestCase.assertEquals((String)"navigation handler", (String)navigationHandlerType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testViewHandler() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ViewHandlerType viewHandlerType = (ViewHandlerType)FacesConfigModelUtil.findEObjectElementById((List)application1.getViewHandler(), "viewHandler1");
            ReadApplicationTestCase.assertNotNull((Object)viewHandlerType);
            ReadApplicationTestCase.assertEquals((String)"view handler", (String)viewHandlerType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testStateManager() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            StateManagerType stateManagerType = (StateManagerType)FacesConfigModelUtil.findEObjectElementById((List)application1.getStateManager(), "stateManager1");
            ReadApplicationTestCase.assertNotNull((Object)stateManagerType);
            ReadApplicationTestCase.assertEquals((String)"state manager", (String)stateManagerType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSingleVariableResolver() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            VariableResolverType variableResolverType = (VariableResolverType)FacesConfigModelUtil.findEObjectElementById((List)application1.getVariableResolver(), "variableResolver1");
            ReadApplicationTestCase.assertNotNull((Object)variableResolverType);
            ReadApplicationTestCase.assertEquals((String)"com.ibm.faces.databind.SelectItemsVarResolver", (String)variableResolverType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSinglePropertyResolver() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            PropertyResolverType propertyResolverType = (PropertyResolverType)FacesConfigModelUtil.findEObjectElementById((List)application1.getPropertyResolver(), "propertyResolver1");
            ReadApplicationTestCase.assertNotNull((Object)propertyResolverType);
            ReadApplicationTestCase.assertEquals((String)"com.ibm.faces.databind.SelectItemsPropResolver", (String)propertyResolverType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testLocalConfig() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            LocaleConfigType localeConfigType = (LocaleConfigType)FacesConfigModelUtil.findEObjectElementById((List)application1.getLocaleConfig(), "localeConfig1");
            ReadApplicationTestCase.assertNotNull((Object)localeConfigType);
            ReadApplicationTestCase.assertEquals((String)"en", (String)localeConfigType.getDefaultLocale().getTextContent());
            ReadApplicationTestCase.assertEquals((String)"defaultLocale1", (String)localeConfigType.getDefaultLocale().getId());
            ReadApplicationTestCase.assertEquals((int)2, (int)localeConfigType.getSupportedLocale().size());
            SupportedLocaleType supportedLocaleType = (SupportedLocaleType)FacesConfigModelUtil.findEObjectElementById((List)localeConfigType.getSupportedLocale(), "supportedLocale_en");
            ReadApplicationTestCase.assertNotNull((Object)supportedLocaleType);
            ReadApplicationTestCase.assertEquals((String)"en", (String)supportedLocaleType.getTextContent().trim());
            supportedLocaleType = (SupportedLocaleType)FacesConfigModelUtil.findEObjectElementById((List)localeConfigType.getSupportedLocale(), "supportedLocale_de");
            ReadApplicationTestCase.assertNotNull((Object)supportedLocaleType);
            ReadApplicationTestCase.assertEquals((String)"de", (String)supportedLocaleType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

