/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchPageScoreComputer;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class EditorInputAdapterFactory
implements IAdapterFactory {
    private static Class[] PROPERTIES = new Class[]{IJavaScriptElement.class};
    private Object fSearchPageScoreComputer;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IJavaScriptElement.class.equals((Object)key) && element instanceof IEditorInput) {
            IJavaScriptUnit je = JavaScriptUI.getWorkingCopyManager().getWorkingCopy((IEditorInput)element);
            if (je != null) {
                return je;
            }
            if (element instanceof IStorageEditorInput) {
                try {
                    return ((IStorageEditorInput)element).getStorage().getAdapter(key);
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new JavaSearchPageScoreComputer();
        PROPERTIES = new Class[]{ISearchPageScoreComputer.class, IJavaScriptElement.class};
    }
}

