/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ElementImplTests
extends TestCase {
    private static final String contents = "<elementPrefix:localName attrPrefix:local='lorem' xmlns:elementPrefix='urn:prefix' xmlns:attributePrefix='urn:attribute:prefix' />";
    private static final String decl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static /* synthetic */ Class class$0;

    public ElementImplTests() {
    }

    public ElementImplTests(String name) {
        super(name);
    }

    public void testElementImplPrefix() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute prefix was not as expected", (String)"elementPrefix", (String)documentElement.getPrefix());
    }

    public void testElementImplLocalName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"localName", (String)documentElement.getLocalName());
    }

    public void testAttrBasedElementNamespace() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertNotNull((String)"Namespace was not found.", (Object)documentElement.getNamespaceURI());
        String namespace = documentElement.getNamespaceURI();
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"urn:prefix", (String)namespace);
    }

    public void testNamespaceURIOnCreation() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element element = model.getDocument().createElement("simple");
        ElementImplTests.assertNull((String)"namespace was found", (Object)element.getNamespaceURI());
        Element element2 = model.getDocument().createElementNS("http://lorem.ipsum", "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", (String)"http://lorem.ipsum", (String)element2.getNamespaceURI());
        Element element3 = model.getDocument().createElementNS(null, "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", null, (String)element3.getNamespaceURI());
    }

    public void testGetElementsByTagNameNoChildren() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("root");
        document.appendChild(root);
        NodeList children = root.getElementsByTagName("*");
        ElementImplTests.assertEquals((int)0, (int)children.getLength());
    }

    public void testGetElementsByTagNameChildren() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("root");
        document.appendChild(root);
        root.appendChild(document.createElement("child"));
        root.appendChild(document.createElement("child"));
        NodeList children = root.getElementsByTagName("*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameChildrenBySameName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("child");
        document.appendChild(root);
        root.appendChild(document.createElement("child"));
        root.appendChild(document.createElement("child"));
        NodeList children = root.getElementsByTagName("child");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        NodeList children = root.getElementsByTagNameNS("http://test", "*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNSTestNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test2:child"));
        NodeList children = root.getElementsByTagNameNS("http://test", "*");
        ElementImplTests.assertEquals((int)2, (int)children.getLength());
    }

    public void testGetElementsByTagNameNSAnyNS() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test:child"));
        root.appendChild(document.createElement("test2:child"));
        NodeList children = root.getElementsByTagNameNS("*", "*");
        ElementImplTests.assertEquals((int)3, (int)children.getLength());
    }

    public void testRemoveNonexistantAttrByName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(decl);
        IDOMDocument document = model.getDocument();
        Element root = document.createElement("test:root");
        root.setAttribute("xmlns:test", "http://test");
        root.setAttribute("xmlns:test2", "http://test2");
        document.appendChild(root);
        boolean success = false;
        try {
            root.removeAttribute(this.getName());
            success = true;
        }
        catch (DOMException ex) {
            ElementImplTests.assertTrue((String)"threw_NOT_FOUND_ERR", (ex.code != 8 ? 1 : 0) != 0);
        }
        ElementImplTests.assertTrue((String)"threw exception", (boolean)success);
    }

    /*
     * Exception decompiling
     */
    public void testSetAttrWithImpliedDefault() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 95->99)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testRemoveAttrWithImpliedDefault() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 116->120)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testOwnerElementWithImpliedDefaultAttribute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCMAttrWithNullImpliedValue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 88->92)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStructuredModel getModelForRead(String path) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + path);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(path).toString();
            model = modelManager.getModelForRead(baseFile, inStream, new URIResolver(baseFile){
                String fBase;
                {
                    this.fBase = string;
                }

                public String getFileBaseLocation() {
                    return this.fBase;
                }

                public String getLocationByURI(String uri) {
                    return this.getLocationByURI(uri, this.fBase);
                }

                public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri);
                }

                public String getLocationByURI(String uri, String baseReference) {
                    int lastSlash = baseReference.lastIndexOf("/");
                    if (lastSlash > 0) {
                        return String.valueOf(baseReference.substring(0, lastSlash + 1)) + uri;
                    }
                    return baseReference;
                }

                public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri, baseReference);
                }

                public IProject getProject() {
                    return null;
                }

                public IContainer getRootLocation() {
                    return null;
                }

                public InputStream getURIStream(String uri) {
                    return this.getClass().getResourceAsStream(this.getLocationByURI(uri));
                }

                public void setFileBaseLocation(String newLocation) {
                    this.fBase = newLocation;
                }

                public void setProject(IProject newProject) {
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }
}

