/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class CamelCasingTests
extends TestCase {
    private static final String TEST_NAME = "Test Camel Casing JavaScript Content Assist.";
    private static TestProjectSetup fTestProjectSetup;
    static /* synthetic */ Class class$0;

    public CamelCasingTests() {
        super(TEST_NAME);
    }

    public CamelCasingTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.ui.tests.contentassist.CamelCasingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testCamelCasing_Expression1() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam", "iGotMessage(param1) - iGotMessage"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "ConstructorCamelCase.html", 8, 6, expectedProposals);
    }

    public void testCamelCasing_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun", "mail.iGotSpam(a, b) - mail.iGotSpam"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "ConstructorCamelCase.html", 10, 7, expectedProposals);
    }

    public void testCamelCasing_Expression2_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"iGotMessage(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "ConstructorCamelCase.html", 2, 7, expectedProposals, true, false);
    }

    public void testCamelCasing_Expression3() throws Exception {
        String[][] expectedProposals = new String[][]{{"mail.inbox.iGotStarredFun(param1) - mail.inbox.iGotStarredFun"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "ConstructorCamelCase.html", 12, 8, expectedProposals);
    }

    public void testGlobalVar_Expresssion1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 12, 3, expectedProposals);
    }

    public void testGlobalVar_Expresssion2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalVarNum : Number - Global", "globalVar - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 14, 2, expectedProposals);
    }

    public void testDoublyNestedFunc_CamelCasing_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"outerFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerOuter.html", 8, 2, expectedProposals);
    }
}

