/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.parser;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionChecker;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrTest4
extends TestCase {
    private StringWriter fOutputWriter;

    public AttrTest4() {
    }

    public AttrTest4(String name) {
        super(name);
    }

    private IDOMModel createModel() {
        IDOMModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = (IDOMModel)modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public void printDOMDocument(IDOMModel model) {
        this.printStructuredDocument(model.getStructuredDocument());
        new StructuredDocumentRegionChecker((Writer)this.fOutputWriter).checkModel(model);
        this.fOutputWriter.write("Tree :\n");
        this.printNode((Node)model.getDocument(), 0);
    }

    private void printNode(Node node, int indent) {
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < indent) {
            buffer.append("--");
            ++i;
        }
        buffer.append(StringUtils.escape((String)node.toString()));
        this.fOutputWriter.write(buffer.toString());
        this.fOutputWriter.write(10);
        ++indent;
        Node child = node.getFirstChild();
        while (child != null) {
            this.printNode(child, indent);
            child = child.getNextSibling();
        }
    }

    protected void printStructuredDocument(IStructuredDocument document) {
        this.fOutputWriter.write("StructuredDocument Regions :\n");
        IStructuredDocumentRegion flatnode = document.getFirstStructuredDocumentRegion();
        while (flatnode != null) {
            this.fOutputWriter.write(flatnode.toString());
            this.fOutputWriter.write(10);
            flatnode = flatnode.getNext();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fOutputWriter = new StringWriter();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrName() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a href=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 11] (<a href=''>)\n[11, 15] (text)\n[15, 19] (</a>)\nTree :\n#document\n--a/a@[0, 11] (<a href&#61;''>)@[15, 19] (</a>)\n----#text(text)@[11, 15] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"href", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"href", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameAltogether() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a [(*ngFor)]=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 17] (<a [(*ngFor)]=''>)\n[17, 21] (text)\n[21, 25] (</a>)\nTree :\n#document\n--a/a@[0, 17] (<a [(*ngFor)]&#61;''>)@[21, 25] (</a>)\n----#text(text)@[17, 21] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[(*ngFor)]", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[(*ngFor)]", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameBracket() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a [href]=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a [href]=''>)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a [href]&#61;''>)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[href]", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[href]", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameLeadingHash() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a #ngFor=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a #ngFor=''>)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a #ngFor&#61;''>)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"#ngFor", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"#ngFor", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameParentheses() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a (click)=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 14] (<a (click)=''>)\n[14, 18] (text)\n[18, 22] (</a>)\nTree :\n#document\n--a/a@[0, 14] (<a (click)&#61;''>)@[18, 22] (</a>)\n----#text(text)@[14, 18] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"(click)", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"(click)", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameSplat() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a *ngFor=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a *ngFor=''>)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a *ngFor&#61;''>)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"*ngFor", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"*ngFor", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNameTrailingHash() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.setText((Object)this, "<a ngFor#=''>text</a>");
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a ngFor#=''>)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a ngFor#&#61;''>)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"ngFor#", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"ngFor#", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNodeAltogether() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IDOMDocument document = model.getDocument();
            Element anchor = document.createElement("a");
            anchor.setAttribute("[(*ngFor)]", "");
            anchor.appendChild(document.createTextNode("text"));
            document.appendChild(anchor);
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 17] (<a [(*ngFor)]=\"\">)\n[17, 21] (text)\n[21, 25] (</a>)\nTree :\n#document\n--a/a@[0, 17] (<a [(*ngFor)]&#61;\"\">)@[21, 25] (</a>)\n----#text(text)@[17, 21] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[(*ngFor)]", (String)model.getStructuredDocument().getFirstStructuredDocumentRegion().getText(model.getStructuredDocument().getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[(*ngFor)]", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNodeBracket() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IDOMDocument document = model.getDocument();
            Element anchor = document.createElement("a");
            anchor.setAttribute("[href]", "");
            anchor.appendChild(document.createTextNode("text"));
            document.appendChild(anchor);
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a [href]=\"\">)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a [href]&#61;\"\">)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[href]", (String)model.getStructuredDocument().getFirstStructuredDocumentRegion().getText(model.getStructuredDocument().getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"[href]", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttrNodeSplat() {
        IDOMModel model = null;
        try {
            model = this.createModel();
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            IDOMDocument document = model.getDocument();
            Element anchor = document.createElement("a");
            anchor.setAttribute("*ngFor", "");
            anchor.appendChild(document.createTextNode("text"));
            document.appendChild(anchor);
            this.printDOMDocument(model);
            AttrTest4.assertEquals((String)"Not as expected", (String)"StructuredDocument Regions :\n[0, 13] (<a *ngFor=\"\">)\n[13, 17] (text)\n[17, 21] (</a>)\nTree :\n#document\n--a/a@[0, 13] (<a *ngFor&#61;\"\">)@[17, 21] (</a>)\n----#text(text)@[13, 17] (text)\n", (String)this.fOutputWriter.toString());
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"*ngFor", (String)structuredDocument.getFirstStructuredDocumentRegion().getText(structuredDocument.getFirstStructuredDocumentRegion().getRegions().get(2)));
            AttrTest4.assertEquals((String)"Wrong attribute name", (String)"*ngFor", (String)model.getDocument().getDocumentElement().getAttributes().item(0).getNodeName());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        model.releaseFromEdit();
    }
}

