/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AbstractJavaCorrectionPropsoal;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUnimplementedMethodCorrectionProposal
extends AbstractJavaCorrectionPropsoal {
    private ASTNode typeDeclaration;
    private String endpointInterface;

    public AddUnimplementedMethodCorrectionProposal(IInvocationContext invocationContext, ASTNode typeDeclaration, String endpointInterface, String displayString, int relevance, Image image) {
        super(invocationContext, displayString, relevance, image);
        this.endpointInterface = endpointInterface;
        this.typeDeclaration = typeDeclaration;
    }

    @Override
    public void addEdits(TextFileChange textChange) throws CoreException {
        IMethodBinding[] unimplementedMethods = this.getUnimplementedMethods(this.typeDeclaration, this.endpointInterface);
        if (unimplementedMethods.length == 0) {
            return;
        }
        ICompilationUnit compilationUnit = this.invocationContext.getCompilationUnit();
        CompilationUnit astRoot = this.invocationContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)compilationUnit.getJavaProject());
        settings.overrideAnnotation = false;
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)this.typeDeclaration;
        ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty());
        ImportRewrite importRewrite = ImportRewrite.create((CompilationUnit)astRoot, (boolean)true);
        int i = 0;
        while (i < unimplementedMethods.length) {
            IMethodBinding methodBinding = unimplementedMethods[i];
            MethodDeclaration methodDeclaration = StubUtility2.createImplementationStub((ICompilationUnit)compilationUnit, (ASTRewrite)rewriter, (ImportRewrite)importRewrite, (ImportRewrite.ImportRewriteContext)importRewrite.getDefaultImportRewriteContext(), (IMethodBinding)methodBinding, (ITypeBinding)methodBinding.getDeclaringClass(), (CodeGenerationSettings)settings, (boolean)false, (IBinding)methodBinding.getDeclaringClass());
            listRewrite.insertLast((ASTNode)methodDeclaration, null);
            ++i;
        }
        textChange.addEdit(rewriter.rewriteAST());
        if (importRewrite.hasRecordedChanges()) {
            textChange.addEdit(importRewrite.rewriteImports(null));
        }
    }

    public IMethodBinding[] getMethodsToImplement() {
        return this.getUnimplementedMethods(this.typeDeclaration, this.endpointInterface);
    }

    private IMethodBinding[] getUnimplementedMethods(ASTNode typeDeclaration, String endpointInterface) {
        CompilationUnit implementationCompilationUnit;
        ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
        if (typeDeclaration.getParent() instanceof CompilationUnit && (implementationCompilationUnit = (CompilationUnit)typeDeclaration.getParent()).getJavaElement() instanceof ICompilationUnit) {
            try {
                IJavaProject javaProject = implementationCompilationUnit.getJavaElement().getJavaProject();
                IType seiType = javaProject.findType(endpointInterface);
                if (seiType != null) {
                    ICompilationUnit sei = seiType.getCompilationUnit();
                    CompilationUnit seiCompilationUnit = this.getAST(sei);
                    List<MethodDeclaration> implementationMethods = this.getMethodDeclarations(implementationCompilationUnit);
                    List<MethodDeclaration> seiMethods = this.getMethodDeclarations(seiCompilationUnit);
                    for (MethodDeclaration seiMethod : seiMethods) {
                        boolean implemented = false;
                        for (MethodDeclaration implMethod : implementationMethods) {
                            if (!AnnotationUtils.compareMethods((MethodDeclaration)seiMethod, (MethodDeclaration)implMethod)) continue;
                            implemented = true;
                            break;
                        }
                        if (implemented) continue;
                        methodBindings.add(seiMethod.resolveBinding());
                    }
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return methodBindings.toArray(new IMethodBinding[methodBindings.size()]);
    }

    private List<MethodDeclaration> getMethodDeclarations(CompilationUnit compilationUnit) {
        final ArrayList<MethodDeclaration> methodDeclarations = new ArrayList<MethodDeclaration>();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration methodDeclaration) {
                methodDeclarations.add(methodDeclaration);
                return false;
            }
        });
        return methodDeclarations;
    }
}

