/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterfaceAnnotationLocationType;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateEnterpriseBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.StateType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSessionBeanTemplateModel
extends CreateEnterpriseBeanTemplateModel {
    public static final String QUALIFIED_STATELESS = "javax.ejb.Stateless";
    public static final String QUALIFIED_STATEFUL = "javax.ejb.Stateful";
    public static final String QUALIFIED_SINGLETON = "javax.ejb.Singleton";
    public static final String QUALIFIED_LOCAL_BEAN = "javax.ejb.LocalBean";
    public static final String QUALIFIED_LOCAL = "javax.ejb.Local";
    public static final String QUALIFIED_REMOTE = "javax.ejb.Remote";
    public static final String QUALIFIED_REMOTE_HOME = "javax.ejb.RemoteHome";
    public static final String QUALIFIED_LOCAL_HOME = "javax.ejb.LocalHome";
    public static final String QUALIFIED_ASYNCHRONOUS = "javax.ejb.Asynchronous";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT_TYPE = "javax.ejb.TransactionManagementType";
    public static final String STATELESS_ANNOTATION = "@Stateless";
    public static final String STATEFUL_ANNOTATION = "@Stateful";
    public static final String SINGLETON_ANNOTATION = "@Singleton";
    protected BusinessInterface currentBusinessInterface = null;
    protected String localHomeClassName = null;
    protected String localComponentClassName = null;
    protected String remoteHomeClassName = null;
    protected String remoteComponentClassName = null;

    public CreateSessionBeanTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        String stateType = this.dataModel.getStringProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType.equals(StateType.STATELESS.toString())) {
            collection.add(QUALIFIED_STATELESS);
        } else if (stateType.equals(StateType.STATEFUL.toString())) {
            collection.add(QUALIFIED_STATEFUL);
        } else if (stateType.equals(StateType.SINGLETON.toString())) {
            collection.add(QUALIFIED_SINGLETON);
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        if (!this.isContainerType()) {
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT);
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT_TYPE);
        }
        if (this.isRemoteHomeChecked()) {
            collection.add(QUALIFIED_REMOTE_HOME);
            collection.add(this.remoteHomeClassName);
        }
        if (this.isLocalHomeChecked()) {
            collection.add(QUALIFIED_LOCAL_HOME);
            collection.add(this.localHomeClassName);
        }
        if (this.isNoInterfaceChecked()) {
            collection.add(QUALIFIED_LOCAL_BEAN);
        }
        if (this.isAsynchronous()) {
            collection.add(QUALIFIED_ASYNCHRONOUS);
        }
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        if (this.addBusinessAnnotationToBeanClass()) {
            for (BusinessInterface iface : interfaces) {
                if (iface.isLocal()) {
                    collection.add(QUALIFIED_LOCAL);
                    continue;
                }
                if (!iface.isRemote()) continue;
                collection.add(QUALIFIED_REMOTE);
            }
        } else {
            for (BusinessInterface iface : interfaces) {
                if (iface.isLocal() && iface.exists()) {
                    collection.add(QUALIFIED_LOCAL);
                    continue;
                }
                if (!iface.isRemote() || !iface.exists()) continue;
                collection.add(QUALIFIED_REMOTE);
            }
        }
        return collection;
    }

    public List<String> getQualifiedInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            result.add(iface.getFullyQualifiedName());
        }
        return result;
    }

    public String getClassAnnotation() {
        String beanType;
        String stateType = this.dataModel.getStringProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType.equals(StateType.STATELESS.toString())) {
            beanType = STATELESS_ANNOTATION;
        } else if (stateType.equals(StateType.STATEFUL.toString())) {
            beanType = STATEFUL_ANNOTATION;
        } else if (stateType.equals(StateType.SINGLETON.toString())) {
            beanType = SINGLETON_ANNOTATION;
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        return beanType;
    }

    public List<BusinessInterface> getBusinessInterfaces() {
        return (List)this.dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
    }

    public List<BusinessInterface> getLocalBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isLocal()) continue;
            result.add(iface);
        }
        return result;
    }

    public List<BusinessInterface> getExistingLocalBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isLocal() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public List<BusinessInterface> getRemoteBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isRemote()) continue;
            result.add(iface);
        }
        return result;
    }

    public List<BusinessInterface> getExistingRemoteBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isRemote() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public boolean isLocalHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
    }

    public boolean isRemoteHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
    }

    public boolean isNoInterfaceChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.NO_INTERFACE");
    }

    public boolean isAsynchronous() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.ASYNC");
    }

    public Map<String, String> getClassAnnotationParams() {
        String mappedName;
        Hashtable<String, String> result = new Hashtable<String, String>();
        String dispName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME").trim();
        if (!dispName.equals(this.getClassName()) && dispName.length() > 0) {
            result.put("name", dispName);
        }
        if ((mappedName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.MAPPED_NAME").trim()) != null && mappedName.length() > 0) {
            result.put("mappedName", mappedName);
        }
        return result;
    }

    public void setCurrentBusinessInterface(BusinessInterface newBI) {
        this.currentBusinessInterface = newBI;
    }

    public String getBusinessInterfaceJavaPackageName() {
        String packageName = null;
        if (this.currentBusinessInterface != null) {
            packageName = Signature.getQualifier((String)this.currentBusinessInterface.getFullyQualifiedName());
        }
        return packageName;
    }

    public String getBusinessInterfaceClassName() {
        String className = null;
        if (this.currentBusinessInterface != null) {
            className = this.currentBusinessInterface.getSimpleName();
        }
        return className;
    }

    public String getLocalHomePackage() {
        return Signature.getQualifier((String)this.localHomeClassName);
    }

    public String getLocalHomeClassSimpleName() {
        return Signature.getSimpleName((String)this.localHomeClassName);
    }

    public void setLocalHomeClassName(String localHomeClassName) {
        this.localHomeClassName = localHomeClassName;
    }

    public String getLocalComponentPackage() {
        return Signature.getQualifier((String)this.localComponentClassName);
    }

    public String getLocalComponentClassSimpleName() {
        return Signature.getSimpleName((String)this.localComponentClassName);
    }

    public void setLocalComponentClassName(String localComponentClassName) {
        this.localComponentClassName = localComponentClassName;
    }

    public String getRemoteHomePackage() {
        return Signature.getQualifier((String)this.remoteHomeClassName);
    }

    public String getRemoteHomeClassSimpleName() {
        return Signature.getSimpleName((String)this.remoteHomeClassName);
    }

    public void setRemoteHomeClassName(String remoteHomeClassName) {
        this.remoteHomeClassName = remoteHomeClassName;
    }

    public String getRemoteComponentPackage() {
        return Signature.getQualifier((String)this.remoteComponentClassName);
    }

    public String getRemoteComponentClassSimpleName() {
        return Signature.getSimpleName((String)this.remoteComponentClassName);
    }

    public void setRemoteComponentClassName(String remoteComponentClassName) {
        this.remoteComponentClassName = remoteComponentClassName;
    }

    public boolean addBusinessAnnotationToBeanClass() {
        String prop = this.dataModel.getStringProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACE_ANNOTATION_LOCATION");
        return prop.equals(BusinessInterfaceAnnotationLocationType.BEAN_CLASS_ONLY.toString()) || prop.equals(BusinessInterfaceAnnotationLocationType.BEAN_CLASS_AND_INTERFACE.toString());
    }

    public boolean addBusinessAnnotationToInterface() {
        String prop = this.dataModel.getStringProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACE_ANNOTATION_LOCATION");
        return prop.equals(BusinessInterfaceAnnotationLocationType.INTERFACE_ONLY.toString()) || prop.equals(BusinessInterfaceAnnotationLocationType.BEAN_CLASS_AND_INTERFACE.toString());
    }
}

