/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.jmock;

import java.util.Collection;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.jmock.core.Constraint;
import org.jmock.core.DynamicMock;
import org.jmock.core.Formatting;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.MockObjectSupportTestCase;
import org.jmock.core.Stub;
import org.jmock.core.Verifiable;
import org.jmock.core.matcher.InvokeAtLeastOnceMatcher;
import org.jmock.core.matcher.InvokeAtMostOnceMatcher;
import org.jmock.core.matcher.InvokeCountMatcher;
import org.jmock.core.matcher.InvokeOnceMatcher;
import org.jmock.core.matcher.TestFailureMatcher;
import org.jmock.core.stub.ReturnIteratorStub;
import org.jmock.core.stub.ReturnStub;
import org.jmock.core.stub.ThrowStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMockObjectTestCase
extends MockObjectSupportTestCase {
    public AbstractMockObjectTestCase() {
    }

    public AbstractMockObjectTestCase(String name) {
        super(name);
    }

    public <T> Mock<T> mock(Class mockedType) {
        return this.mock(mockedType, this.defaultMockNameForType(mockedType));
    }

    public <T> Mock<T> mock(Class mockedType, String roleName) {
        Mock newMock = new Mock(this.newCoreMock(mockedType, roleName));
        this.registerToVerify((Verifiable)newMock);
        return newMock;
    }

    protected abstract <T> DynamicMock newCoreMock(Class<T> var1, String var2);

    public String defaultMockNameForType(Class<?> mockedType) {
        return "mock" + Formatting.classShortName(mockedType);
    }

    public Stub returnValue(Object o) {
        return new ReturnStub(o);
    }

    public Stub returnValue(boolean result) {
        return this.returnValue(new Boolean(result));
    }

    public Stub returnValue(byte result) {
        return this.returnValue(new Byte(result));
    }

    public Stub returnValue(char result) {
        return this.returnValue(new Character(result));
    }

    public Stub returnValue(short result) {
        return this.returnValue(new Short(result));
    }

    public Stub returnValue(int result) {
        return this.returnValue(new Integer(result));
    }

    public Stub returnValue(long result) {
        return this.returnValue(new Long(result));
    }

    public Stub returnValue(float result) {
        return this.returnValue(new Float(result));
    }

    public Stub returnValue(double result) {
        return this.returnValue(new Double(result));
    }

    public Stub returnIterator(Collection<?> collection) {
        return new ReturnIteratorStub(collection);
    }

    public Stub returnIterator(Object[] array) {
        return new ReturnIteratorStub(array);
    }

    public Stub throwException(Throwable throwable) {
        return new ThrowStub(throwable);
    }

    public InvocationMatcher once() {
        return new InvokeOnceMatcher();
    }

    public InvocationMatcher atLeastOnce() {
        return new InvokeAtLeastOnceMatcher();
    }

    public InvocationMatcher atMostOnce() {
        return new InvokeAtMostOnceMatcher();
    }

    public InvocationMatcher exactly(int expectedCount) {
        return new InvokeCountMatcher(expectedCount);
    }

    public InvocationMatcher never() {
        return new TestFailureMatcher("not expected");
    }

    public InvocationMatcher never(String errorMessage) {
        return new TestFailureMatcher("not expected (" + errorMessage + ")");
    }

    public Stub onConsecutiveCalls(Stub ... stubs) {
        return this.onConsecutiveCalls(stubs);
    }

    public Stub doAll(Stub ... stubs) {
        return this.doAll(stubs);
    }

    public Constraint collectionWithElements(final int expectedCollectionSize, final Object ... objects) {
        return new Constraint(){

            public boolean eval(Object arg0) {
                Collection col = (Collection)arg0;
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (!col.contains(o)) {
                        return false;
                    }
                    ++n2;
                }
                return objects.length == expectedCollectionSize;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        };
    }
}

