/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.osgi.framework.Bundle;

public class PluginProcessorJar
implements IProcessorJar {
    private final String pluginId;
    private final IPath path;

    public PluginProcessorJar(String pluginId, IPath path) {
        this.pluginId = pluginId;
        this.path = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL asURL() {
        URL url = null;
        try {
            if (this.path != null) {
                Path jarPath;
                Bundle bundle = Platform.getBundle((String)this.pluginId);
                url = FileLocator.find((Bundle)bundle, (IPath)(jarPath = new Path("/" + this.path)), null);
                if (url == null) return url;
                return FileLocator.resolve((URL)url);
            }
            Bundle bundle = Platform.getBundle((String)this.pluginId);
            if (bundle == null) {
                return null;
            }
            url = bundle.getEntry("/");
            String s = (url = FileLocator.resolve((URL)url)).getPath();
            if (!s.endsWith("!/")) return new URL(s);
            s = s.substring(0, s.length() - 2);
            return new URL(s);
        }
        catch (IOException e) {
            JAXPLaunchingPlugin.log(e);
        }
        return url;
    }

    public IPath getPath() {
        return this.path;
    }

    public String toString() {
        return "Plugin " + this.pluginId + Messages.PluginProcessorJar_0 + this.path;
    }
}

