/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationReader;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public final class CompletionProposoalCatigoriesConfigurationRegistry {
    private static final String EXTENSION_POINT = "completionProposalCategoriesConfiguration";
    private static final String ELEM_CATEGORIES_PROPERTIES = "categoriesConfiguration";
    private static final String ATTR_CONTENT_TYPE_ID = "contentTypeID";
    private static final String ATTR_CLASS = "class";
    private static CompletionProposoalCatigoriesConfigurationRegistry fgSingleton = null;
    private boolean fLoaded = false;
    private Map fPropertiesByContentTypeID = new HashMap();

    public static synchronized CompletionProposoalCatigoriesConfigurationRegistry getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new CompletionProposoalCatigoriesConfigurationRegistry();
        }
        return fgSingleton;
    }

    private CompletionProposoalCatigoriesConfigurationRegistry() {
    }

    public ICompletionProposalCategoriesConfigurationReader getReadableConfiguration(String contentTypeID) {
        this.ensureLoaded();
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
        while (contentType != null) {
            String id = contentType.getId();
            if (this.fPropertiesByContentTypeID.containsKey(id)) {
                contentTypeID = id;
                break;
            }
            contentType = contentType.getBaseType();
        }
        return (ICompletionProposalCategoriesConfigurationReader)this.fPropertiesByContentTypeID.get(contentTypeID);
    }

    public ICompletionProposalCategoriesConfigurationWriter getWritableConfiguration(String contentTypeID) {
        this.ensureLoaded();
        ICompletionProposalCategoriesConfigurationReader reader = this.getReadableConfiguration(contentTypeID);
        ICompletionProposalCategoriesConfigurationWriter writer = null;
        if (reader instanceof ICompletionProposalCategoriesConfigurationWriter) {
            writer = (ICompletionProposalCategoriesConfigurationWriter)reader;
        }
        return writer;
    }

    private void ensureLoaded() {
        if (!this.fLoaded) {
            this.load();
            this.fLoaded = true;
        }
    }

    private void load() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> extensionElements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.wst.sse.ui", EXTENSION_POINT)));
        Iterator elementsIter = extensionElements.iterator();
        while (elementsIter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)elementsIter.next();
            try {
                if (element.getName().equals(ELEM_CATEGORIES_PROPERTIES)) {
                    String contentTypeID = element.getAttribute(ATTR_CONTENT_TYPE_ID);
                    ContentAssistUtils.checkExtensionAttributeNotNull(contentTypeID, ATTR_CONTENT_TYPE_ID, element);
                    String pageClass = element.getAttribute(ATTR_CLASS);
                    ContentAssistUtils.checkExtensionAttributeNotNull(pageClass, ATTR_CLASS, element);
                    ICompletionProposalCategoriesConfigurationReader props = (ICompletionProposalCategoriesConfigurationReader)element.createExecutableExtension(ATTR_CLASS);
                    if (!this.fPropertiesByContentTypeID.containsKey(contentTypeID)) {
                        this.fPropertiesByContentTypeID.put(contentTypeID, props);
                        continue;
                    }
                    Logger.log(4, "Extension " + element.getDeclaringExtension() + " is attempting to to define itself as the proposal cateigories" + " configuration for content type " + contentTypeID + " when another" + " extensions has already done so.");
                    continue;
                }
                Logger.log(2, "The element " + element + " is not valid for the" + "org.eclipse.wst.sse.ui.completionProposalCategoriesConfiguration" + " extension point.  Only " + ELEM_CATEGORIES_PROPERTIES + " elements are valid.");
            }
            catch (InvalidRegistryObjectException x) {
                String message = "The extension ''" + element.toString() + "'' has become invalid.";
                Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, (Throwable)x);
                Logger.log((IStatus)status);
            }
            catch (CoreException x) {
                Logger.log(x.getStatus());
            }
        }
    }
}

