/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.modelhandler;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.wst.jsdt.web.core.internal.modelhandler.IWebResourceChangedListener;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class WebResourceChangeHandler
implements IResourceChangeListener,
IDocumentListener,
IModelLifecycleListener {
    private static Hashtable instances = new Hashtable();
    private static final boolean SIGNAL_MODEL = false;
    private ArrayList fchangeListener = new ArrayList();
    private ModelIrritantThread irritator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebResourceChangeHandler getInstance(IStructuredModel xmlModel, IWebResourceChangedListener changeListener) {
        WebResourceChangeHandler handler = null;
        Hashtable hashtable = instances;
        synchronized (hashtable) {
            Enumeration values = instances.elements();
            while (values.hasMoreElements()) {
                Object model = values.nextElement();
                if (model != xmlModel) continue;
                handler = (WebResourceChangeHandler)instances.get(model);
            }
            if (handler == null) {
                handler = new WebResourceChangeHandler();
                instances.put(handler, xmlModel);
            }
        }
        handler.initialize();
        handler.fchangeListener.add(changeListener);
        return handler;
    }

    private WebResourceChangeHandler() {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.irritator.signalAllDirtyModel();
    }

    public boolean equals(Object o) {
        return o instanceof WebResourceChangeHandler && ((WebResourceChangeHandler)o).fchangeListener == this.fchangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        IStructuredModel fXMLModel;
        IStructuredDocument fJspDocument;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (instances == null) {
            return;
        }
        Object o = null;
        Hashtable hashtable = instances;
        synchronized (hashtable) {
            o = instances.get(this);
            instances.remove(this);
        }
        if (o != null && (fJspDocument = (fXMLModel = (IStructuredModel)o).getStructuredDocument()) != null) {
            fJspDocument.removeDocumentListener((IDocumentListener)this);
        }
    }

    private IStructuredModel getModel() {
        if (instances == null) {
            return null;
        }
        return (IStructuredModel)instances.get(this);
    }

    private void initialize() {
        IStructuredModel xmlModel = this.getModel();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        xmlModel.addModelLifecycleListener((IModelLifecycleListener)this);
        IStructuredDocument fJspDocument = xmlModel.getStructuredDocument();
        if (fJspDocument != null) {
            fJspDocument.addDocumentListener((IDocumentListener)this);
        }
        this.irritator = new ModelIrritantThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPostModelEvent(ModelLifecycleEvent event) {
        if (this.irritator != null) {
            this.irritator.signalAllDirtyModel();
        }
        if (instances == null) {
            return;
        }
        if (event.getType() == 2) {
            Hashtable hashtable = instances;
            synchronized (hashtable) {
                instances.remove(this);
            }
        }
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        FileBuffers.getTextFileBufferManager().execute((Runnable)this.irritator);
    }

    static /* synthetic */ IStructuredModel access$1(WebResourceChangeHandler webResourceChangeHandler) {
        return webResourceChangeHandler.getModel();
    }

    private class ModelIrritantThread
    implements Runnable {
        private ModelIrritantThread() {
        }

        public void run() {
            this.signalAllDirtyModel();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void signalAllDirtyModel() {
            int i = 0;
            while (i < WebResourceChangeHandler.this.fchangeListener.size()) {
                ((IWebResourceChangedListener)WebResourceChangeHandler.this.fchangeListener.get(i)).resourceChanged();
                ++i;
            }
        }
    }
}

