/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal.http;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.internet.monitor.core.internal.Connection;
import org.eclipse.wst.internet.monitor.core.internal.ProtocolAdapterDelegate;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPConnection;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPThread;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;

public class HTTPProtocolAdapter
extends ProtocolAdapterDelegate {
    protected Map<IMonitor, Connection> map = new HashMap<IMonitor, Connection>();

    public void connect(IMonitor monitor, Socket in, Socket out) throws IOException {
        Connection conn2 = new Connection(in, out);
        this.map.put(monitor, conn2);
        HTTPConnection conn = new HTTPConnection(monitor);
        HTTPThread request = new HTTPThread(conn2, in.getInputStream(), out.getOutputStream(), conn, true, monitor.getRemoteHost(), monitor.getRemotePort());
        HTTPThread response = new HTTPThread(conn2, out.getInputStream(), in.getOutputStream(), conn, false, "localhost", monitor.getLocalPort(), request);
        request.start();
        response.start();
    }

    public void disconnect(IMonitor monitor) throws IOException {
        try {
            Connection conn = this.map.get(monitor);
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {}
    }
}

