package org.example.www.participant;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class DerbyDatabase
{
    private static String dbLocation = "c:/db-derby-10.1.1.0-bin/data/participant";
    private static String dbURL = "jdbc:derby:";
    private static Connection conn = null;
    private static Statement stmt = null;
    private static String driverName = "org.apache.derby.jdbc.EmbeddedDriver";
    
    public static Connection getConnInstance()
    {
    	if (conn == null)
    	{
    		conn = createConnection("","");
    	}
    	return conn;
    }
    
    private static Connection createConnection(String userName, String password)
    {
        try
        {
            Class.forName(driverName);
            Properties dbProps = new Properties();
            dbProps.put("user", userName);
            dbProps.put("password", password);
            conn = DriverManager.getConnection(dbURL + dbLocation, dbProps);
            System.out.println("Connection successful!");
        }
        catch (Exception except)
        {
            System.out.print("Could not connect to the database with username: " + userName);
            System.out.println(" password " + password);
            System.out.println("Check that the Derby Network Server is running on localhost.");
            except.printStackTrace();
        }
        return conn;
    }
    
    public static int executeUpdate(Connection conn, String sql)
    {
        // the number of rows affected by the update or insert
        int numRows = 0;
       
        try
        {
            stmt = conn.createStatement();
            numRows = stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException sqlExcept)
        {
            sqlExcept.printStackTrace();
        }
        return numRows;
    }
    
    public static String[] runQuery(Connection conn, String sql)
    {
        List list = Collections.synchronizedList(new ArrayList(10));
        try
        {
            stmt = conn.createStatement();
            ResultSet results = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = results.getMetaData();
            int numberCols = rsmd.getColumnCount();
       
            while(results.next())
            {
                    StringBuffer sbuf = new StringBuffer(200);
                    for (int i = 1; i <= numberCols; i++)
                    {
                        sbuf.append(results.getString(i));
                        sbuf.append(", ");
                    }
                list.add(sbuf.toString());
            }
            results.close();
            stmt.close();
        }
        catch (SQLException sqlExcept)
        {
            sqlExcept.printStackTrace();
        }
        return (String[])list.toArray(new String[list.size()]);
    }
    
    public static Item getItemDetail(Connection conn, String name)
    {
        String query = "SELECT ITEM_NAME, ITEM_DESCR, ITEM_PRICE, SELLER_NAME, SELLER_EMAIL, WEBSITE FROM APP.ITEMS WHERE ITEM_NAME ='" + name + "'";
        Item item = new Item();
         try
        {
            stmt = conn.createStatement();
             ResultSet results = stmt.executeQuery(query);
 
            while(results.next())
            {
            	
            	 String itemName = results.getString(1);
                 String itemDescr = results.getString(2);
                 Long itemPrice = Long.valueOf(results.getString(3));
                 String sellerName = results.getString(4);
                 String sellerEmail = results.getString(5);
                 String website = results.getString(6);
                 
                 
                 item.setItemName(itemName);
                 item.setItemDescription(itemDescr);
                 item.setPrice(BigDecimal.valueOf(itemPrice.longValue()));
                 item.setSellerName(sellerName);
                 item.setSelllerEmail(sellerEmail);
                 item.setPageAddress(website);
          
            }
            results.close();
            stmt.close();
        }
        catch (SQLException sqlExcept)
        {
            sqlExcept.printStackTrace();
        }
      
        return item;
    }

  
}
