<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

	<xsl:output method="html" />

	<xsl:template match="/">
		<html>
			<head>
				<title>Stock Quotes</title>
			</head>
			<body>
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>

	<xsl:template match="StockQuotes">
		<xsl:variable name="symbol">
			<xsl:choose>
				<xsl:when test="Stock/Symbol">
					<xsl:value-of select="Stock/Symbol" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>IBM</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<h1>Get Quote</h1>
		<p>
			Enter a stock symbol and click the button to get the latest
			price.
		</p>
		<form action="getQuote-xsl.jsp">
			<table cellspacing="4">
				<tr>
					<th>Symbol:</th>
					<td>
						<input type="text" name="symbol" value="{$symbol}"
							size="4" />
					</td>
					<td>
						<input type="submit" value="Get Quote" />
					</td>
				</tr>
			</table>
		</form>
		<table cellspacing="4">
			<tr>
				<th>Symbol</th>
				<th>Last</th>
				<th>Date</th>
				<th>Time</th>
			</tr>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="Stock">
		<tr>
			<td>
				<xsl:value-of select="Symbol" />
			</td>
			<td>
				<xsl:value-of select="Last" />
			</td>
			<td>
				<xsl:value-of select="Date" />
			</td>
			<td>
				<xsl:value-of select="Time" />
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>