<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

	<xsl:output method="html" />

	<xsl:template match="/schedule">
		<html>
			<head>
				<title>
					<xsl:value-of
						select="concat(league,' ', name,' Schedule')" />
				</title>
				<link rel="stylesheet" href="schedule.css"
					type="text/css" />

			</head>
			<body>
				<h1>
					<xsl:value-of select="league" />
				</h1>
				<h2>
					<xsl:value-of select="concat(name,' Schedule')" />
				</h2>
				<xsl:apply-templates select="games" />
				<xsl:call-template name="email" />
			</body>
		</html>
	</xsl:template>

	<xsl:template match="games">
		<table>
			<thead>
				<tr>
					<th>Date</th>
					<th>Time</th>
					<th>Arena</th>
					<th>Visitor</th>
					<th>Home</th>
					<th>Score</th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="game">
					<tr>
						<xsl:attribute name="class">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:text>odd-row</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>even-row</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<td>
							<xsl:value-of select="date" />
						</td>
						<td>
							<xsl:value-of select="time" />
						</td>
						<td>
							<xsl:value-of select="arena" />
						</td>
						<td>
							<xsl:value-of select="visitor" />
						</td>
						<td>
							<xsl:value-of select="home" />
						</td>
						<td>
							<xsl:value-of select="score" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>

	<xsl:template name="email">
		<br />
		<hr />
		<script language="JavaScript">
			<![CDATA[
var protocol = "mailto"; 
var user = "webmaster"; 
var server = "leagueplanet.com"; 
function contact() {
	window.open(protocol + ":" + user + "@" + server, "_self");
}
]]>
		</script>

		<p>
			For questions about this Web page, please contact
			<a href="javascript:contact()">
				webmaster at leagueplanet dot com
			</a>
		</p>
	</xsl:template>

</xsl:stylesheet>