package com.leagueplanet.services;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.dao.example.IceHockeyDOAImpl;
import com.leagueplanet.services.LeagueFacade;
import com.leagueplanet.services.impl.LeagueFacadeImpl;

public class IceHockeyFacade {
	
	private static LeagueFacade facade = null;
	
	public static LeagueFacade getLeagueFacade() {
		if (facade == null) {
			init();
		}
		
		return facade;
	}
	
	private static void init() {
		
		// create a new facade implementation
		LeagueFacadeImpl facadeImpl = new LeagueFacadeImpl();
		
		// point the facade at the dao for the ice hockey league
		LeagueDAO dao = IceHockeyDOAImpl.getLeagueDAO();
		facadeImpl.setLeagueDAO(dao);
		
		facade = facadeImpl;
	}

}
