/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.PackageGenerator;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.actions.ProjectAction;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateEntitiesAction
extends ProjectAction {
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.targetPart = targetPart;
    }

    protected void execute(PersistenceProject project) {
        GenerateEntitiesWizard wizard = new GenerateEntitiesWizard(project, this.getCurrentSelection());
        WizardDialog dialog = new WizardDialog(PersistenceUiPlugin.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0) {
            GenerateEntitiesRunnable runnable = new GenerateEntitiesRunnable(wizard.getPackageGeneratorConfig(), wizard.getEntityGeneratorConfig(), wizard.getSelectedTables(), new OverwriteConfirmer(this.targetPart.getSite().getShell()));
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static class GenerateEntitiesRunnable
    implements IWorkspaceRunnable {
        private final PackageGenerator.Config packageConfig;
        private final EntityGenerator.Config entityConfig;
        private final Collection selectedTables;
        private final EntityGenerator.OverwriteConfirmer overwriteConfirmer;

        GenerateEntitiesRunnable(PackageGenerator.Config packageConfig, EntityGenerator.Config entityConfig, Collection selectedTables, EntityGenerator.OverwriteConfirmer overwriteConfirmer) {
            this.packageConfig = packageConfig;
            this.entityConfig = entityConfig;
            this.selectedTables = selectedTables;
            this.overwriteConfirmer = overwriteConfirmer;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            monitor.beginTask("", 1000);
            try {
                PackageGenerator.generateEntities((PackageGenerator.Config)this.packageConfig, (EntityGenerator.Config)this.entityConfig, (Collection)this.selectedTables, (EntityGenerator.OverwriteConfirmer)this.overwriteConfirmer, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
            monitor.done();
        }
    }

    static class OverwriteConfirmer
    implements EntityGenerator.OverwriteConfirmer {
        private Shell shell;
        private boolean overwriteAll = false;
        private boolean skipAll = false;

        OverwriteConfirmer(Shell shell) {
            this.shell = shell;
        }

        public boolean overwrite(String className) {
            if (this.overwriteAll) {
                return true;
            }
            if (this.skipAll) {
                return false;
            }
            return this.promptUser(className);
        }

        private boolean promptUser(String className) {
            OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(this.shell, className);
            if (dialog.open() == 1) {
                throw new OperationCanceledException();
            }
            if (dialog.yes()) {
                return true;
            }
            if (dialog.yesToAll()) {
                this.overwriteAll = true;
                return true;
            }
            if (dialog.no()) {
                return false;
            }
            if (dialog.noToAll()) {
                this.skipAll = true;
                return false;
            }
            throw new IllegalStateException();
        }
    }

    static class OverwriteConfirmerDialog
    extends Dialog {
        private final String className;
        private boolean yes = false;
        private boolean yesToAll = false;
        private boolean no = false;
        private boolean noToAll = false;

        OverwriteConfirmerDialog(Shell parent, String className) {
            super(parent);
            this.className = className;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(DaliUiMessages.OverwriteConfirmerDialog_title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = (GridLayout)composite.getLayout();
            gridLayout.numColumns = 2;
            Label text = new Label(composite, 16384);
            text.setText(NLS.bind((String)DaliUiMessages.OverwriteConfirmerDialog_text, (Object)this.className));
            text.setLayoutData((Object)new GridData());
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.yesPressed();
                    break;
                }
                case 4: {
                    this.yesToAllPressed();
                    break;
                }
                case 3: {
                    this.noPressed();
                    break;
                }
                case 21: {
                    this.noToAllPressed();
                    break;
                }
                case 1: {
                    this.cancelPressed();
                    break;
                }
            }
        }

        private void yesPressed() {
            this.yes = true;
            this.setReturnCode(0);
            this.close();
        }

        private void yesToAllPressed() {
            this.yesToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noPressed() {
            this.no = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noToAllPressed() {
            this.noToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        boolean yes() {
            return this.yes;
        }

        boolean yesToAll() {
            return this.yesToAll;
        }

        boolean no() {
            return this.no;
        }

        boolean noToAll() {
            return this.noToAll;
        }
    }
}

