/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection;

import org.eclipse.dali.ui.selection.AbstractSelectionParticipant;
import org.eclipse.dali.ui.selection.ISelectionManager;
import org.eclipse.dali.ui.selection.Selection;
import org.eclipse.dali.ui.selection.SelectionEvent;
import org.eclipse.dali.ui.views.PersistenceOutlineView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class PersistenceOutlineSelectionParticipant
extends AbstractSelectionParticipant {
    private PersistenceOutlineView outlineView;
    private ISelectionChangedListener outlineListener;

    public PersistenceOutlineSelectionParticipant(ISelectionManager theSelectionManager, PersistenceOutlineView theView) {
        super(theSelectionManager);
        this.outlineView = theView;
        this.outlineListener = new OutlineSelectionListener();
        this.outlineView.addSelectionChangedListener(this.outlineListener);
    }

    public Selection getSelection() {
        return this.outlineView.getSelection();
    }

    public void selectionChanged(SelectionEvent evt) {
        this.outlineView.select(evt.getSelection());
    }

    public boolean disposeOnHide() {
        return false;
    }

    public void dispose() {
        this.outlineView.removeSelectionChangedListener(this.outlineListener);
    }

    private class OutlineSelectionListener
    implements ISelectionChangedListener {
        private OutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PersistenceOutlineSelectionParticipant.this.selectionManager.select(PersistenceOutlineSelectionParticipant.this.outlineView.getSelection());
        }
    }
}

