/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.db.ui.NewConnectionWizard;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.JPAProjectFieldData;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class JPAProjectContentPage
extends DataModelWizardPage {
    private Connection connection;
    private ConnectionListener connectionListener;
    private JPAProjectFieldData fieldData;
    private JavaProjectProvider projectProvider;
    private DatabaseGroup databaseGroup;
    private ClassPathConfigGroup classPathConfigGroup;
    private PackagingGroup packagingGroup;

    public static JPAProjectContentPage buildJavaProjectConstructingPage(String pageName, IDataModel model, JPAProjectFieldData jpaProjectFieldData) {
        JPAProjectContentPage page;
        JPAProjectContentPage jPAProjectContentPage = page = new JPAProjectContentPage(pageName, model, jpaProjectFieldData);
        ((Object)((Object)jPAProjectContentPage)).getClass();
        page.setJavaProjectProvider(jPAProjectContentPage.new JavaProjectConstructor());
        return page;
    }

    public static JPAProjectContentPage buildJavaProjectHoldingPage(String pageName, IDataModel model, JPAProjectFieldData jpaProjectFieldData, IJavaProject javaProject) {
        JPAProjectContentPage page;
        JPAProjectContentPage jPAProjectContentPage = page = new JPAProjectContentPage(pageName, model, jpaProjectFieldData);
        ((Object)((Object)jPAProjectContentPage)).getClass();
        page.setJavaProjectProvider(jPAProjectContentPage.new JavaProjectHolder(javaProject));
        return page;
    }

    public JPAProjectContentPage(String pageName, IDataModel model, JPAProjectFieldData theFieldData) {
        super(model, pageName);
        this.fieldData = theFieldData;
    }

    private void setJavaProjectProvider(JavaProjectProvider javaProjectProvider) {
        this.projectProvider = javaProjectProvider;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"JPAProjectDataModelProperties.CREATE_PERSISTENCE_XML", "JPAProjectDataModelProperties.PERSISTENCE_PROVIDER", "JPAProjectDataModelProperties.PERSISTENCE_UNIT_NAME"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.databaseGroup = new DatabaseGroup(composite);
        this.classPathConfigGroup = new ClassPathConfigGroup(composite);
        this.packagingGroup = new PackagingGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.dali.ui.dialog_addPersistence");
        return composite;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 30;
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2052);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    private Button createButton(Composite container, int style, int span, int indent) {
        Button button = new Button(container, style);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Text createText(Composite container) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public void updateData() {
        this.model.setStringProperty("JPAProjectDataModelProperties.PROJECT_NAME", this.projectProvider.getJavaProject().getProject().getName());
        this.fieldData.setConnectionName(this.databaseGroup.getConnectionName());
        this.fieldData.setSchemaName(this.databaseGroup.getSchemaName());
    }

    public void dispose() {
        this.removeConnectionListener();
        super.dispose();
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            if (this.connection != null) {
                this.connection.removeConnectionListener(this.connectionListener);
            }
            this.connectionListener = null;
        }
    }

    private final class DatabaseGroup {
        private final Group group;
        private final Label connectionLabel;
        private final Combo connectionCombo;
        private final Label schemaLabel;
        private final Combo schemaCombo;
        private final Label schemaInfo;
        private Link connectionLink;
        private Link openConnectionLink;

        public DatabaseGroup(Composite composite) {
            this.group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setText(DaliUiMessages.JPAProjectContentPage_database);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.group, "org.eclipse.dali.ui.dialog_addJavaPersistence_database");
            this.connectionLabel = JPAProjectContentPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.JPAProjectContentPage_databaseConnection);
            this.connectionCombo = JPAProjectContentPage.this.createCombo((Composite)this.group, true);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$0(this.this$1);
                }
            });
            this.schemaLabel = JPAProjectContentPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.JPAProjectContentPage_schema);
            this.schemaCombo = JPAProjectContentPage.this.createCombo((Composite)this.group, true);
            this.schemaInfo = JPAProjectContentPage.this.createLabel((Composite)this.group, 2, DaliUiMessages.JPAProjectContentPage_schemaInfo);
            this.connectionLink = new Link((Composite)this.group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(DaliUiMessages.JPAProjectCreationPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$1(this.this$1);
                }
            });
            this.openConnectionLink = new Link((Composite)this.group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.openConnectionLink.setLayoutData((Object)data);
            this.openConnectionLink.setText(DaliUiMessages.JPAProjectCreationPage_openConnectionLink);
            this.openConnectionLink.setEnabled(false);
            this.openConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$3(this.this$1, DatabaseGroup.access$2(this.this$1).getText());
                }
            });
            this.fillConnections();
            this.fillSchemas();
        }

        private Connection openConnectionNamed(String connectionName) {
            if (JPAProjectContentPage.this.connection != null) {
                JPAProjectContentPage.this.removeConnectionListener();
            }
            JPAProjectContentPage.this.connection = PersistenceDbPlugin.getDefault().getConnectionRepository().openConnectionNamed(connectionName);
            if (JPAProjectContentPage.this.connection != null) {
                this.fillSchemas();
                JPAProjectContentPage.this.connectionListener = this.buildConnectionListener(JPAProjectContentPage.this.connection);
                JPAProjectContentPage.this.connection.addConnectionListener(JPAProjectContentPage.this.connectionListener);
            }
            return JPAProjectContentPage.this.connection;
        }

        private void fillConnections() {
            this.connectionCombo.removeAll();
            Iterator stream = CollectionTools.sort((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames());
            while (stream.hasNext()) {
                this.connectionCombo.add((String)stream.next());
            }
        }

        private void handleConnectionChange() {
            this.openConnectionLink.setEnabled(true);
            this.fillSchemas();
        }

        private void fillSchemas() {
            this.schemaCombo.removeAll();
            Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.getConnectionName());
            Iterator stream = CollectionTools.sort((Iterator)connection.getDatabase().schemaNames());
            while (stream.hasNext()) {
                this.schemaCombo.add((String)stream.next());
            }
            Schema schema = connection.getDatabase().schemaNamed(connection.getUserName());
            if (schema != null && schema.getName() != null) {
                this.schemaCombo.select(this.schemaCombo.indexOf(schema.getName()));
            }
        }

        private String getConnectionName() {
            return this.connectionCombo.getText();
        }

        private String getSchemaName() {
            return this.schemaCombo.getText();
        }

        private void openNewConnectionWizard() {
            NewConnectionWizard wizard = new NewConnectionWizard(true);
            wizard.setExistingConnectionNames(CollectionTools.list((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames()));
            wizard.init(PlatformUI.getWorkbench(), null);
            wizard.setNeedsProgressMonitor(true);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            Connection connection = wizard.getConnectionWrapper();
            if (connection != null) {
                this.fillConnections();
                this.connectionCombo.select(this.connectionCombo.indexOf(connection.getName()));
                this.handleConnectionChange();
            }
        }

        private ConnectionListener buildConnectionListener(Connection connectionInfo) {
            return new ConnectionListener(this, connectionInfo){
                final /* synthetic */ DatabaseGroup this$1;
                private final /* synthetic */ Connection val$connectionInfo;
                {
                    this.this$1 = databaseGroup;
                    this.val$connectionInfo = connection;
                }

                public void connectionInfoRenamed(String previousName, Connection connection) {
                }

                public void connected(Connection connection) {
                }

                public void disconnected(Connection connection) {
                }

                public void sharedConnectionAdded(Connection connection) {
                }

                public void sharedConnectionRemove(Connection connection) {
                }

                public void schemaChanged(Schema schema) {
                }

                public void tableChanged(Table table) {
                }

                public void databaseAdded(Connection connection, Database database) {
                    if (this.val$connectionInfo.equals(connection)) {
                        DatabaseGroup.access$4(this.this$1);
                    }
                }

                public void databaseRemove(Connection connection, Database database) {
                    if (this.val$connectionInfo.equals(connection)) {
                        JPAProjectContentPage.access$3(DatabaseGroup.access$7(this.this$1));
                    }
                }

                public void onSQLException(Connection connection, SQLException exception) {
                    this.val$connectionInfo.equals(connection);
                }
            };
        }

        static /* synthetic */ void access$0(DatabaseGroup databaseGroup) {
            databaseGroup.handleConnectionChange();
        }

        static /* synthetic */ void access$1(DatabaseGroup databaseGroup) {
            databaseGroup.openNewConnectionWizard();
        }

        static /* synthetic */ Combo access$2(DatabaseGroup databaseGroup) {
            return databaseGroup.connectionCombo;
        }

        static /* synthetic */ Connection access$3(DatabaseGroup databaseGroup, String string) {
            return databaseGroup.openConnectionNamed(string);
        }

        static /* synthetic */ void access$4(DatabaseGroup databaseGroup) {
            databaseGroup.fillSchemas();
        }

        static /* synthetic */ JPAProjectContentPage access$7(DatabaseGroup databaseGroup) {
            return databaseGroup.JPAProjectContentPage.this;
        }
    }

    private final class ClassPathConfigGroup {
        private final Group group;
        private Label noConfigLabel;
        private Link configClassPathLink;

        public ClassPathConfigGroup(Composite composite) {
            this.group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setText(DaliUiMessages.JPAProjectContentPage_classpathConfig);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.group, "org.eclipse.dali.ui.dialog_addJavaPersistence_classpath");
            boolean noConfig = false;
            try {
                noConfig = JPAProjectContentPage.this.projectProvider.getJavaProject().getProject().hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
            }
            catch (CoreException ce) {
                throw new RuntimeException(ce);
            }
            if (noConfig) {
                this.createNoConfigLabel(this.group);
            } else {
                this.createConfigComposite(this.group);
            }
        }

        private void createNoConfigLabel(Group group) {
            this.noConfigLabel = new Label((Composite)group, 0);
            this.noConfigLabel.setText(DaliUiMessages.JPAProjectContentPage_noConfig);
        }

        private void createConfigComposite(Group group) {
            Composite composite = new Composite((Composite)group, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.configClassPathLink = new Link(composite, 0);
            this.configClassPathLink.setText(DaliUiMessages.JPAProjectContentPage_configClassPath);
            this.configClassPathLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ClassPathConfigGroup this$1;
                {
                    this.this$1 = classPathConfigGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    ClassPathConfigGroup.access$0(this.this$1);
                }
            });
        }

        private void promptToConfigureBuildPath() {
            PreferencesUtil.createPropertyDialogOn((Shell)JPAProjectContentPage.this.getShell(), (IAdaptable)JPAProjectContentPage.this.projectProvider.getJavaProject().getProject(), (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
        }

        static /* synthetic */ void access$0(ClassPathConfigGroup classPathConfigGroup) {
            classPathConfigGroup.promptToConfigureBuildPath();
        }
    }

    private final class PackagingGroup {
        private final Group group;
        private final Button createPackagingButton;
        private final Label versionLabel;
        private final Combo versionCombo;
        private final Label providerLabel;
        private final Text providerText;
        private final Label punitNameLabel;
        private final Text punitNameText;

        public PackagingGroup(Composite composite) {
            this.group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setText(DaliUiMessages.JPAProjectContentPage_packaging);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.group, "org.eclipse.dali.ui.dialog_addJavaPersistence_packaging");
            this.createPackagingButton = JPAProjectContentPage.this.createButton((Composite)this.group, 32, 2, 0);
            this.createPackagingButton.setText(DaliUiMessages.JPAProjectContentPage_createPackaging);
            this.createPackagingButton.setSelection(true);
            this.createPackagingButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PackagingGroup this$1;
                {
                    this.this$1 = packagingGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = PackagingGroup.access$0(this.this$1).getSelection();
                    PackagingGroup.access$1(this.this$1).setEnabled(selected);
                    PackagingGroup.access$2(this.this$1).setEnabled(selected);
                    PackagingGroup.access$3(this.this$1).setEnabled(selected);
                    PackagingGroup.access$4(this.this$1).setEnabled(selected);
                }
            });
            JPAProjectContentPage.this.synchHelper.synchCheckbox(this.createPackagingButton, "JPAProjectDataModelProperties.CREATE_PERSISTENCE_XML", null);
            this.versionLabel = JPAProjectContentPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.JPAProjectContentPage_persistenceVersion);
            this.versionCombo = JPAProjectContentPage.this.createCombo((Composite)this.group, false);
            JPAProjectContentPage.this.synchHelper.synchCombo(this.versionCombo, "JPAProjectDataModelProperties.PERSISTENCE_VERSION", null);
            this.providerLabel = JPAProjectContentPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.JPAProjectContentPage_provider);
            this.providerText = JPAProjectContentPage.this.createText((Composite)this.group);
            JPAProjectContentPage.this.synchHelper.synchText(this.providerText, "JPAProjectDataModelProperties.PERSISTENCE_PROVIDER", null);
            this.punitNameLabel = JPAProjectContentPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.JPAProjectContentPage_persistenceUnitName);
            this.punitNameText = JPAProjectContentPage.this.createText((Composite)this.group);
            JPAProjectContentPage.this.synchHelper.synchText(this.punitNameText, "JPAProjectDataModelProperties.PERSISTENCE_UNIT_NAME", null);
        }

        static /* synthetic */ Button access$0(PackagingGroup packagingGroup) {
            return packagingGroup.createPackagingButton;
        }

        static /* synthetic */ Label access$1(PackagingGroup packagingGroup) {
            return packagingGroup.providerLabel;
        }

        static /* synthetic */ Text access$2(PackagingGroup packagingGroup) {
            return packagingGroup.providerText;
        }

        static /* synthetic */ Label access$3(PackagingGroup packagingGroup) {
            return packagingGroup.punitNameLabel;
        }

        static /* synthetic */ Text access$4(PackagingGroup packagingGroup) {
            return packagingGroup.punitNameText;
        }
    }

    public static interface JavaProjectProvider {
        public IJavaProject getJavaProject();
    }

    private class JavaProjectConstructor
    implements JavaProjectProvider {
        private JavaProjectConstructor() {
        }

        public IJavaProject getJavaProject() {
            return null;
        }
    }

    private class JavaProjectHolder
    implements JavaProjectProvider {
        private IJavaProject javaProject;

        private JavaProjectHolder(IJavaProject aJavaProject) {
            this.javaProject = aJavaProject;
        }

        public IJavaProject getJavaProject() {
            return this.javaProject;
        }
    }
}

