/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.orm.impl.PersistenceModelManager;
import org.eclipse.dali.packaging.internal.PackagingInit;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.BundleContext;

public final class DaliPlugin
extends Plugin {
    private static DaliPlugin INSTANCE;
    public static final String PLUGIN_ID = "org.eclipse.dali.core";
    public static final String NATURE_ID = "org.eclipse.dali.core.persistenceNature";

    public static void addPersistenceNature(IJavaProject javaProject, String connectionInfoName, String schemaName) throws CoreException {
        PersistenceModelManager.instance().addPersistenceNature(javaProject, connectionInfoName, schemaName);
    }

    public static boolean projectHasPersistenceNature(IJavaProject javaProject) {
        try {
            return javaProject.getProject().getNature(NATURE_ID) != null;
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static PersistenceProject persistenceProject(IProject project) {
        return PersistenceModelManager.instance().getPersistenceProject(project);
    }

    public static PersistenceFile getPersistenceFile(IFile file) {
        return PersistenceModelManager.instance().getPersistenceFile(file);
    }

    public static void log(Throwable e) {
        DaliPlugin.log((IStatus)new Status(4, DaliPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        DaliPlugin.getPlugin().getLog().log(status);
    }

    public static DaliPlugin getPlugin() {
        return INSTANCE;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public DaliPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PersistenceModelManager.instance().startup();
        PackagingInit.init();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            PersistenceModelManager.instance().shutdown();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public Iterator annotationMappingConfigurationElements() {
        ArrayList<IConfigurationElement> annotationMappings = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(DaliPlugin.getPluginId()) + ".mappings");
        int j = 0;
        while (j < configurationElements.length) {
            String tagName;
            IConfigurationElement configurationElement = configurationElements[j];
            if (configurationElement.getName().equals("mapping") && (tagName = configurationElement.getAttribute("annotationName")) != null) {
                annotationMappings.add(configurationElement);
            }
            ++j;
        }
        return annotationMappings.iterator();
    }

    public Iterator possibleAnnotationsMappings() {
        return new TransformationIterator(this.annotationMappingConfigurationElements()){

            protected Object transform(Object next) {
                return ((IConfigurationElement)next).getAttribute("annotationName");
            }
        };
    }

    public Iterator defaultAnnotationMappingConfigurationElements() {
        ArrayList<IConfigurationElement> annotationMappings = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(DaliPlugin.getPluginId()) + ".defaultMappings");
        int j = 0;
        while (j < configurationElements.length) {
            String annotationName;
            IConfigurationElement configurationElement = configurationElements[j];
            if (configurationElement.getName().equals("mapping") && (annotationName = configurationElement.getAttribute("annotationName")) != null) {
                annotationMappings.add(configurationElement);
            }
            ++j;
        }
        return annotationMappings.iterator();
    }

    public Iterator possibleDefaultAnnotationMappings() {
        return new TransformationIterator(this.defaultAnnotationMappingConfigurationElements()){

            protected Object transform(Object next) {
                return ((IConfigurationElement)next).getAttribute("annotationName");
            }
        };
    }

    public Iterator possibleXMLMappings() {
        return new TransformationIterator(this.xmlMappingConfigurationElements()){

            protected Object transform(Object next) {
                return ((IConfigurationElement)next).getAttribute("xmlTagName");
            }
        };
    }

    public Iterator xmlMappingConfigurationElements() {
        ArrayList<IConfigurationElement> xmlMappings = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(DaliPlugin.getPluginId()) + ".mappings");
        int j = 0;
        while (j < configurationElements.length) {
            String tagName;
            IConfigurationElement configurationElement = configurationElements[j];
            if (configurationElement.getName().equals("mapping") && (tagName = configurationElement.getAttribute("xmlTagName")) != null) {
                xmlMappings.add(configurationElement);
            }
            ++j;
        }
        return xmlMappings.iterator();
    }
}

