/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Stack;
import org.eclipse.dali.internal.utility.StringTools;

public final class ClassTools {
    public static final Class[] ZERO_PARAMETER_TYPES = new Class[0];
    public static final Object[] ZERO_PARAMETERS = new Object[0];
    private static final String CR = StringTools.CR;
    public static final char NESTED_CLASS_NAME_SEPARATOR = '$';
    public static final char ARRAY_INDICATOR = '[';
    public static final char REFERENCE_CLASS_CODE = 'L';
    public static final char REFERENCE_CLASS_NAME_DELIMITER = ';';
    private static PrimitiveClassCode[] PRIMITIVE_CLASS_CODES;
    public static final char BYTE_CODE = 'B';
    public static final char CHAR_CODE = 'C';
    public static final char DOUBLE_CODE = 'D';
    public static final char FLOAT_CODE = 'F';
    public static final char INT_CODE = 'I';
    public static final char LONG_CODE = 'J';
    public static final char SHORT_CODE = 'S';
    public static final char BOOLEAN_CODE = 'Z';
    public static final char VOID_CODE = 'V';
    private static int MAX_PRIMITIVE_CLASS_NAME_LENGTH;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        MAX_PRIMITIVE_CLASS_NAME_LENGTH = -1;
    }

    public static Field[] allFields(Class javaClass) {
        Stack stack = new Stack();
        Class tempClass = javaClass;
        while (tempClass != null) {
            ClassTools.pushDeclaredFields(tempClass, stack);
            tempClass = tempClass.getSuperclass();
        }
        Collections.reverse(stack);
        return stack.toArray(new Field[stack.size()]);
    }

    public static Method[] allMethods(Class javaClass) {
        Stack stack = new Stack();
        Class tempClass = javaClass;
        while (tempClass != null) {
            ClassTools.pushDeclaredMethods(tempClass, stack);
            tempClass = tempClass.getSuperclass();
        }
        Collections.reverse(stack);
        return stack.toArray(new Method[stack.size()]);
    }

    public static Object attemptNewInstance(Class javaClass) throws NoSuchMethodException {
        return ClassTools.attemptNewInstance(javaClass, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptNewInstance(Class javaClass, Class[] parameterTypes, Object[] parameters) throws NoSuchMethodException {
        try {
            return ClassTools.constructor(javaClass, parameterTypes).newInstance(parameters);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie + CR + ClassTools.fullyQualifiedConstructorSignature(javaClass, parameterTypes), ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + ClassTools.fullyQualifiedConstructorSignature(javaClass, parameterTypes), iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(String.valueOf(ClassTools.fullyQualifiedConstructorSignature(javaClass, parameterTypes)) + CR + ite.getTargetException(), ite);
        }
    }

    public static Object attemptNewInstance(Class javaClass, Class parameterType, Object parameter) throws NoSuchMethodException {
        return ClassTools.attemptNewInstance(javaClass, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object attemptToGetFieldValue(Object object, String fieldName) throws NoSuchFieldException {
        try {
            return ClassTools.field(object, fieldName).get(object);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + ClassTools.fullyQualifiedFieldName(object, fieldName), iae);
        }
    }

    public static Object attemptToGetStaticFieldValue(Class javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return ClassTools.field(javaClass, fieldName).get(null);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + ClassTools.fullyQualifiedFieldName(javaClass, fieldName), iae);
        }
    }

    public static Object attemptToInvokeMethod(Object receiver, String methodName) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeMethod(receiver, methodName, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptToInvokeMethod(Object receiver, String methodName, Class parameterType, Object parameter) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeMethod(receiver, methodName, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object attemptToInvokeMethod(Object receiver, String methodName, Class[] parameterTypes, Object[] parameters) throws NoSuchMethodException {
        return ClassTools.invokeMethod(ClassTools.method(receiver, methodName, parameterTypes), receiver, parameters);
    }

    public static Object attemptToInvokeMethodWithException(Object receiver, String methodName, Class[] parameterTypes, Object[] parameters) throws Throwable, NoSuchMethodException {
        return ClassTools.invokeMethodWithException(ClassTools.method(receiver, methodName, parameterTypes), receiver, parameters);
    }

    public static Object attemptToInvokeStaticMethod(Class javaClass, String methodName) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeStaticMethod(javaClass, methodName, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptToInvokeStaticMethod(Class javaClass, String methodName, Class[] parameterTypes, Object[] parameters) throws NoSuchMethodException {
        return ClassTools.invokeStaticMethod(ClassTools.staticMethod(javaClass, methodName, parameterTypes), parameters);
    }

    public static Object attemptToInvokeStaticMethod(Class javaClass, String methodName, Class parameterType, Object parameter) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeStaticMethod(javaClass, methodName, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static void attemptToSetFieldValue(Object object, String fieldName, Object fieldValue) throws NoSuchFieldException {
        try {
            ClassTools.field(object, fieldName).set(object, fieldValue);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + ClassTools.fullyQualifiedFieldName(object, fieldName), iae);
        }
    }

    public static void attemptToSetStaticFieldValue(Class javaClass, String fieldName, Object fieldValue) throws NoSuchFieldException {
        try {
            ClassTools.field(javaClass, fieldName).set(null, fieldValue);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + ClassTools.fullyQualifiedFieldName(javaClass, fieldName), iae);
        }
    }

    public static Constructor constructor(Class javaClass) throws NoSuchMethodException {
        return ClassTools.constructor(javaClass, ZERO_PARAMETER_TYPES);
    }

    public static Constructor constructor(Class javaClass, Class[] parameterTypes) throws NoSuchMethodException {
        Constructor constructor = javaClass.getDeclaredConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    public static Constructor constructor(Class javaClass, Class parameterType) throws NoSuchMethodException {
        return ClassTools.constructor(javaClass, new Class[]{parameterType});
    }

    public static Field[] declaredFields(Class javaClass) {
        Field[] fields = javaClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].setAccessible(true);
            ++i;
        }
        return fields;
    }

    public static Method[] declaredMethods(Class javaClass) {
        Method[] methods = javaClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            methods[i].setAccessible(true);
            ++i;
        }
        return methods;
    }

    public static Constructor defaultConstructor(Class javaClass) throws NoSuchMethodException {
        return ClassTools.constructor(javaClass);
    }

    public static Field field(Class javaClass, String fieldName) throws NoSuchFieldException {
        Field field = null;
        try {
            field = javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ClassTools.field(superclass, fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public static Field field(Object object, String fieldName) throws NoSuchFieldException {
        return ClassTools.field(object.getClass(), fieldName);
    }

    private static String fullyQualifiedConstructorSignature(Class javaClass, Class[] parameterTypes) {
        return ClassTools.fullyQualifiedMethodSignature(javaClass, null, parameterTypes);
    }

    private static String fullyQualifiedFieldName(Class javaClass, String fieldName) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(javaClass.getName());
        sb.append('.');
        sb.append(fieldName);
        return sb.toString();
    }

    private static String fullyQualifiedFieldName(Object object, String fieldName) {
        return ClassTools.fullyQualifiedFieldName(object.getClass(), fieldName);
    }

    private static String fullyQualifiedMethodSignature(Class javaClass, String methodName, Class[] parameterTypes) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(javaClass.getName());
        if (methodName != null) {
            sb.append('.');
            sb.append(methodName);
        }
        sb.append('(');
        int i = 0;
        while (i < parameterTypes.length) {
            sb.append(parameterTypes[i].getName());
            if (i < parameterTypes.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private static String fullyQualifiedMethodSignature(Object receiver, String methodName, Class[] parameterTypes) {
        return ClassTools.fullyQualifiedMethodSignature(receiver.getClass(), methodName, parameterTypes);
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            return ClassTools.attemptToGetFieldValue(object, fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe + CR + ClassTools.fullyQualifiedFieldName(object, fieldName), nsfe);
        }
    }

    public static Object getStaticFieldValue(Class javaClass, String fieldName) {
        try {
            return ClassTools.attemptToGetStaticFieldValue(javaClass, fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe + CR + ClassTools.fullyQualifiedFieldName(javaClass, fieldName), nsfe);
        }
    }

    public static Object invokeMethod(Object receiver, String methodName) {
        return ClassTools.invokeMethod(receiver, methodName, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeMethod(Object receiver, String methodName, Class[] parameterTypes, Object[] parameters) {
        try {
            return ClassTools.attemptToInvokeMethod(receiver, methodName, parameterTypes, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme + CR + ClassTools.fullyQualifiedMethodSignature(receiver, methodName, parameterTypes), nsme);
        }
    }

    public static Object invokeMethod(Object receiver, String methodName, Class parameterType, Object parameter) {
        return ClassTools.invokeMethod(receiver, methodName, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object invokeMethodWithException(Object receiver, String methodName) throws Throwable {
        return ClassTools.invokeMethodWithException(receiver, methodName, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeMethodWithException(Object receiver, String methodName, Class parameterType, Object parameter) throws Throwable {
        return ClassTools.invokeMethodWithException(receiver, methodName, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object invokeMethodWithException(Object receiver, String methodName, Class[] parameterTypes, Object[] parameters) throws Throwable {
        try {
            return ClassTools.attemptToInvokeMethodWithException(receiver, methodName, parameterTypes, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme + CR + ClassTools.fullyQualifiedMethodSignature(receiver, methodName, parameterTypes), nsme);
        }
    }

    public static Object invokeMethod(Method method, Object receiver, Object[] parameters) {
        try {
            return method.invoke(receiver, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + method, iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(method + CR + ite.getTargetException(), ite);
        }
    }

    public static Object invokeMethodWithException(Method method, Object receiver, Object[] parameters) throws Throwable {
        try {
            return method.invoke(receiver, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae + CR + method, iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause == null) {
                throw new RuntimeException(method.toString(), ite);
            }
            throw cause;
        }
    }

    public static Object invokeStaticMethod(Class javaClass, String methodName) {
        return ClassTools.invokeStaticMethod(javaClass, methodName, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeStaticMethod(Class javaClass, String methodName, Class[] parameterTypes, Object[] parameters) {
        try {
            return ClassTools.attemptToInvokeStaticMethod(javaClass, methodName, parameterTypes, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme + CR + ClassTools.fullyQualifiedMethodSignature(javaClass, methodName, parameterTypes), nsme);
        }
    }

    public static Object invokeStaticMethod(Class javaClass, String methodName, Class parameterType, Object parameter) {
        return ClassTools.invokeStaticMethod(javaClass, methodName, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object invokeStaticMethod(Method method, Object[] parameters) {
        return ClassTools.invokeMethod(method, null, parameters);
    }

    public static Method method(Class javaClass, String methodName) throws NoSuchMethodException {
        return ClassTools.method(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method method(Class javaClass, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = javaClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ClassTools.method(superclass, methodName, parameterTypes);
        }
        method.setAccessible(true);
        return method;
    }

    public static Method method(Class javaClass, String methodName, Class parameterType) throws NoSuchMethodException {
        return ClassTools.method(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method method(Object object, String methodName) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), methodName);
    }

    public static Method method(Object object, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), methodName, parameterTypes);
    }

    public static Method method(Object object, String methodName, Class parameterType) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), methodName, parameterType);
    }

    public static Class classForName(String javaClassName) {
        try {
            return Class.forName(javaClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(javaClassName, ex);
        }
    }

    public static Object newInstance(Class javaClass) {
        return ClassTools.newInstance(javaClass, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object newInstance(String javaClassName) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.internal.utility.ClassTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ClassTools.newInstance(javaClassName, clazz.getClassLoader());
    }

    public static Object newInstance(String javaClassName, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(classLoader.loadClass(javaClassName));
    }

    public static Object newInstance(Class javaClass, Class[] parameterTypes, Object[] parameters) {
        try {
            return ClassTools.attemptNewInstance(javaClass, parameterTypes, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme + CR + ClassTools.fullyQualifiedConstructorSignature(javaClass, parameterTypes), nsme);
        }
    }

    public static Object newInstance(String javaClassName, Class[] parameterTypes, Object[] parameters) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.internal.utility.ClassTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ClassTools.newInstance(javaClassName, parameterTypes, parameters, clazz.getClassLoader());
    }

    public static Object newInstance(String javaClassName, Class[] parameterTypes, Object[] parameters, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(classLoader.loadClass(javaClassName), parameterTypes, parameters);
    }

    public static Object newInstance(Class javaClass, Class parameterType, Object parameter) {
        return ClassTools.newInstance(javaClass, new Class[]{parameterType}, new Object[]{parameter});
    }

    public static Object newInstance(String javaClassName, Class parameterType, Object parameter) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.internal.utility.ClassTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ClassTools.newInstance(javaClassName, parameterType, parameter, clazz.getClassLoader());
    }

    public static Object newInstance(String javaClassName, Class parameterType, Object parameter, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(classLoader.loadClass(javaClassName), parameterType, parameter);
    }

    private static void pushDeclaredFields(Class javaClass, Stack stack) {
        Field[] fields = ClassTools.declaredFields(javaClass);
        int i = fields.length - 1;
        while (i >= 0) {
            stack.push(fields[i]);
            --i;
        }
    }

    private static void pushDeclaredMethods(Class javaClass, Stack stack) {
        Method[] methods = ClassTools.declaredMethods(javaClass);
        int i = methods.length - 1;
        while (i >= 0) {
            stack.push(methods[i]);
            --i;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) {
        try {
            ClassTools.attemptToSetFieldValue(object, fieldName, fieldValue);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe + CR + ClassTools.fullyQualifiedFieldName(object, fieldName), nsfe);
        }
    }

    public static void setStaticFieldValue(Class javaClass, String fieldName, Object fieldValue) {
        try {
            ClassTools.attemptToSetStaticFieldValue(javaClass, fieldName, fieldValue);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe + CR + ClassTools.fullyQualifiedFieldName(javaClass, fieldName), nsfe);
        }
    }

    public static String shortClassNameForObject(Object object) {
        return ClassTools.shortNameFor(object.getClass());
    }

    public static String shortNameForClassNamed(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static String shortNameFor(Class javaClass) {
        return ClassTools.shortNameForClassNamed(javaClass.getName());
    }

    public static String nestedClassNameForObject(Object object) {
        return ClassTools.nestedNameFor(object.getClass());
    }

    public static String nestedNameForClassNamed(String className) {
        return className.substring(className.lastIndexOf(36) + 1);
    }

    public static String nestedNameFor(Class javaClass) {
        return ClassTools.nestedNameForClassNamed(javaClass.getName());
    }

    public static String toStringClassNameForObject(Object object) {
        return ClassTools.toStringNameFor(object.getClass());
    }

    public static String toStringNameForClassNamed(String className) {
        return ClassTools.classNamedIsMember(className) ? className.substring(className.lastIndexOf(36) + 1) : className.substring(className.lastIndexOf(46) + 1);
    }

    public static String toStringNameFor(Class javaClass) {
        return ClassTools.toStringNameForClassNamed(javaClass.getName());
    }

    public static String packageNameFor(Class javaClass) {
        return ClassTools.packageNameForClassNamed(javaClass.getName());
    }

    public static String packageNameForClassNamed(String className) {
        int lastPeriod = className.lastIndexOf(46);
        if (lastPeriod == -1) {
            return "";
        }
        return className.substring(0, lastPeriod);
    }

    public static String shortNameWithPackage(Class javaClass) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(ClassTools.shortNameFor(javaClass));
        if (!javaClass.isPrimitive()) {
            sb.append(" (");
            sb.append(ClassTools.packageNameFor(javaClass));
            sb.append(')');
        }
        return sb.toString();
    }

    public static Method staticMethod(Class javaClass, String methodName) throws NoSuchMethodException {
        return ClassTools.staticMethod(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method staticMethod(Class javaClass, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method method = ClassTools.method(javaClass, methodName, parameterTypes);
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException(ClassTools.fullyQualifiedMethodSignature(javaClass, methodName, parameterTypes));
    }

    public static Method staticMethod(Class javaClass, String methodName, Class parameterTypes) throws NoSuchMethodException {
        return ClassTools.staticMethod(javaClass, methodName, new Class[]{parameterTypes});
    }

    public static boolean classNamedIsDeclarable(String className) {
        if (className.charAt(0) == '[') {
            return false;
        }
        int index = className.indexOf(36);
        if (index == -1) {
            return true;
        }
        do {
            if (!Character.isDigit(className.charAt(++index))) continue;
            return false;
        } while ((index = className.indexOf(36, index)) != -1);
        return true;
    }

    public static boolean classNamedIsTopLevel(String className) {
        if (ClassTools.classNamedIsArray(className)) {
            return false;
        }
        return className.indexOf(36) == -1;
    }

    public static boolean classNamedIsMember(String className) {
        if (ClassTools.classNamedIsArray(className)) {
            return false;
        }
        int index = className.indexOf(36);
        if (index == -1) {
            return false;
        }
        do {
            if (!Character.isDigit(className.charAt(++index))) continue;
            return false;
        } while ((index = className.indexOf(36, index)) != -1);
        return true;
    }

    public static boolean classNamedIsLocal(String className) {
        if (ClassTools.classNamedIsArray(className)) {
            return false;
        }
        int dollar = className.indexOf(36);
        if (dollar == -1) {
            return false;
        }
        if (!Character.isDigit(className.charAt(dollar + 1))) {
            return false;
        }
        int i = dollar + 2;
        while (i < className.length()) {
            if (Character.isJavaIdentifierStart(className.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean classNamedIsAnonymous(String className) {
        if (ClassTools.classNamedIsArray(className)) {
            return false;
        }
        int dollar = className.indexOf(36);
        if (dollar == -1) {
            return false;
        }
        int start = dollar + 1;
        int i = className.length();
        while (i-- > start) {
            if (Character.isDigit(className.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int arrayDepthFor(Class javaClass) {
        int depth = 0;
        while (javaClass.isArray()) {
            ++depth;
            javaClass = javaClass.getComponentType();
        }
        return depth;
    }

    public static int arrayDepthForObject(Object object) {
        return ClassTools.arrayDepthFor(object.getClass());
    }

    public static int arrayDepthForClassNamed(String className) {
        int depth = 0;
        while (className.charAt(depth) == '[') {
            ++depth;
        }
        return depth;
    }

    public static boolean classNamedIsArray(String className) {
        return className.charAt(0) == '[';
    }

    public static Class elementTypeFor(Class javaClass) {
        while (javaClass.isArray()) {
            javaClass = javaClass.getComponentType();
        }
        return javaClass;
    }

    public static Class elementTypeForObject(Object object) {
        return ClassTools.elementTypeFor(object.getClass());
    }

    public static String elementTypeNameFor(Class javaClass) {
        return ClassTools.elementTypeFor(javaClass).getName();
    }

    public static String elementTypeNameForClassNamed(String className) {
        int depth = ClassTools.arrayDepthForClassNamed(className);
        if (depth == 0) {
            return className;
        }
        int last = className.length() - 1;
        if (className.charAt(depth) == 'L') {
            return className.substring(depth + 1, last);
        }
        return ClassTools.classNameForCode(className.charAt(last));
    }

    public static boolean classNamedIsReference(String className) {
        return !ClassTools.classNamedIsNonReference(className);
    }

    public static boolean classNamedIsNonReference(String className) {
        if (ClassTools.classNamedIsArray(className) || className.length() > ClassTools.maxPrimitiveClassNameLength()) {
            return false;
        }
        PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
        int i = codes.length;
        while (i-- > 0) {
            if (!codes[i].javaClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static String classNameForCode(char classCode) {
        return ClassTools.classForCode(classCode).getName();
    }

    public static String classNameForCode(int classCode) {
        return ClassTools.classNameForCode((char)classCode);
    }

    public static Class classForCode(char classCode) {
        PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
        int i = codes.length;
        while (i-- > 0) {
            if (codes[i].code != classCode) continue;
            return codes[i].javaClass;
        }
        throw new IllegalArgumentException(String.valueOf(classCode));
    }

    public static Class classForCode(int classCode) {
        return ClassTools.classForCode((char)classCode);
    }

    public static char codeForClass(Class javaClass) {
        if (!javaClass.isArray() && javaClass.getName().length() <= ClassTools.maxPrimitiveClassNameLength()) {
            PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
            int i = codes.length;
            while (i-- > 0) {
                if (codes[i].javaClass != javaClass) continue;
                return codes[i].code;
            }
        }
        throw new IllegalArgumentException(javaClass.getName());
    }

    public static char codeForClassNamed(String className) {
        if (!ClassTools.classNamedIsArray(className) && className.length() <= ClassTools.maxPrimitiveClassNameLength()) {
            PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
            int i = codes.length;
            while (i-- > 0) {
                if (!codes[i].javaClass.getName().equals(className)) continue;
                return codes[i].code;
            }
        }
        throw new IllegalArgumentException(className);
    }

    public static Class classForTypeDeclaration(String elementTypeName, int arrayDepth) throws ClassNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.internal.utility.ClassTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ClassTools.classForTypeDeclaration(elementTypeName, arrayDepth, clazz.getClassLoader());
    }

    public static Class classForTypeDeclaration(String elementTypeName, int arrayDepth, ClassLoader classLoader) throws ClassNotFoundException {
        int i;
        PrimitiveClassCode pcc = null;
        if (elementTypeName.length() <= ClassTools.maxPrimitiveClassNameLength()) {
            PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
            i = codes.length;
            while (i-- > 0) {
                if (!codes[i].javaClass.getName().equals(elementTypeName)) continue;
                pcc = codes[i];
                break;
            }
        }
        if (arrayDepth == 0) {
            return pcc == null ? classLoader.loadClass(elementTypeName) : pcc.javaClass;
        }
        StringBuffer sb = new StringBuffer(100);
        i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        if (pcc == null) {
            sb.append('L');
            sb.append(elementTypeName);
            sb.append(';');
        } else {
            sb.append(pcc.code);
        }
        return classLoader.loadClass(sb.toString());
    }

    public static String classNameForTypeDeclaration(String elementTypeName, int arrayDepth) {
        if (arrayDepth == 0) {
            return elementTypeName;
        }
        if (elementTypeName.equals(Void.TYPE.getName())) {
            throw new IllegalArgumentException("'void' must have an array depth of zero: " + arrayDepth + '.');
        }
        StringBuffer sb = new StringBuffer(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        PrimitiveClassCode pcc = null;
        if (elementTypeName.length() <= ClassTools.maxPrimitiveClassNameLength()) {
            PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
            int i2 = codes.length;
            while (i2-- > 0) {
                if (!codes[i2].javaClass.getName().equals(elementTypeName)) continue;
                pcc = codes[i2];
                break;
            }
        }
        if (pcc == null) {
            sb.append('L');
            sb.append(elementTypeName);
            sb.append(';');
        } else {
            sb.append(pcc.code);
        }
        return sb.toString();
    }

    private static int maxPrimitiveClassNameLength() {
        if (MAX_PRIMITIVE_CLASS_NAME_LENGTH == -1) {
            MAX_PRIMITIVE_CLASS_NAME_LENGTH = ClassTools.calculateMaxPrimitiveClassNameLength();
        }
        return MAX_PRIMITIVE_CLASS_NAME_LENGTH;
    }

    private static int calculateMaxPrimitiveClassNameLength() {
        int max = -1;
        PrimitiveClassCode[] codes = ClassTools.primitiveClassCodes();
        int i = codes.length;
        while (i-- > 0) {
            int len = codes[i].javaClass.getName().length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static PrimitiveClassCode[] primitiveClassCodes() {
        if (PRIMITIVE_CLASS_CODES == null) {
            PRIMITIVE_CLASS_CODES = ClassTools.buildPrimitiveClassCodes();
        }
        return PRIMITIVE_CLASS_CODES;
    }

    private static PrimitiveClassCode[] buildPrimitiveClassCodes() {
        PrimitiveClassCode[] result = new PrimitiveClassCode[]{new PrimitiveClassCode('B', Byte.TYPE), new PrimitiveClassCode('C', Character.TYPE), new PrimitiveClassCode('D', Double.TYPE), new PrimitiveClassCode('F', Float.TYPE), new PrimitiveClassCode('I', Integer.TYPE), new PrimitiveClassCode('J', Long.TYPE), new PrimitiveClassCode('S', Short.TYPE), new PrimitiveClassCode('Z', Boolean.TYPE), new PrimitiveClassCode('V', Void.TYPE)};
        return result;
    }

    private ClassTools() {
        throw new UnsupportedOperationException();
    }

    private static class PrimitiveClassCode {
        char code;
        Class javaClass;

        PrimitiveClassCode(char code, Class javaClass) {
            this.code = code;
            this.javaClass = javaClass;
        }
    }
}

