/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.DiscriminatorColumn;
import org.eclipse.dali.orm.DiscriminatorType;
import org.eclipse.dali.orm.adapters.IDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.IntAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaDiscriminatorColumnModelAdapter
implements IDiscriminatorColumnModelAdapter {
    private DiscriminatorColumn discriminatorColumn;
    private Member member;
    private EnumAnnotationElementAdapter discriminatorTypeAdapter;
    private StringAnnotationElementAdapter discriminatorColumnSpecifiedNameAdapter;
    private StringAnnotationElementAdapter discriminatorColumnDefinitionAdapter;
    private IntAnnotationElementAdapter discriminatorColumnLengthAdapter;
    private static final String DISCRIMINATOR_COLUMN_ANNOTATION = "DiscriminatorColumn";
    private static final String DISCRIMINATOR_TYPE_ENUM = "DiscriminatorType";
    private static final String DISCRIMINATOR_TYPE_ANNOTATION_ELEMENT = "discriminatorType";
    public static final String DISCRIMINATOR_TYPE_STRING = "STRING";
    public static final String DISCRIMINATOR_TYPE_CHAR = "CHAR";
    public static final String DISCRIMINATOR_TYPE_INTEGER = "INTEGER";
    private static final String NAME_ANNOTATION_ELEMENT = "name";
    private static final String COLUMN_DEFINITION_ANNOTATION_ELEMENT = "columnDefinition";
    private static final String LENGTH_ANNOTATION_ELEMENT = "length";

    public JavaDiscriminatorColumnModelAdapter(Member member) {
        this.member = member;
        this.discriminatorTypeAdapter = new EnumAnnotationElementAdapter(this.buildDiscriminatorTypeInfo());
        this.discriminatorColumnSpecifiedNameAdapter = new StringAnnotationElementAdapter(this.buildDiscriminatorColumnSpecifiedNameInfo());
        this.discriminatorColumnDefinitionAdapter = new StringAnnotationElementAdapter(this.buildDiscriminatorColumnDefinitionInfo());
        this.discriminatorColumnLengthAdapter = new IntAnnotationElementAdapter(this.buildDiscriminatorColumnLengthInfo());
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildDiscriminatorTypeInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String discriminatorType) {
                if (discriminatorType == null) {
                    return;
                }
                if (discriminatorType.equals(JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_STRING)) {
                    JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setDiscriminatorType(DiscriminatorType.STRING_LITERAL);
                } else if (discriminatorType.equals(JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_CHAR)) {
                    JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setDiscriminatorType(DiscriminatorType.CHAR_LITERAL);
                } else if (discriminatorType.equals(JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_INTEGER)) {
                    JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setDiscriminatorType(DiscriminatorType.INTEGER_LITERAL);
                } else if (discriminatorType.equals(DiscriminatorType.DEFAULT_LITERAL.getName())) {
                    JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setDiscriminatorType(DiscriminatorType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                DiscriminatorType discriminatorType = JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.getDiscriminatorType();
                if (((Object)((Object)discriminatorType)).equals((Object)DiscriminatorType.STRING_LITERAL)) {
                    return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_STRING;
                }
                if (((Object)((Object)discriminatorType)).equals((Object)DiscriminatorType.CHAR_LITERAL)) {
                    return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_CHAR;
                }
                if (((Object)((Object)discriminatorType)).equals((Object)DiscriminatorType.INTEGER_LITERAL)) {
                    return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_INTEGER;
                }
                return DiscriminatorType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_ENUM;
            }

            public String annotationElementName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_TYPE_ANNOTATION_ELEMENT;
            }

            public String annotationName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_COLUMN_ANNOTATION;
            }

            public Member member() {
                return JavaDiscriminatorColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return DiscriminatorType.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildDiscriminatorColumnSpecifiedNameInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.getSpecifiedName();
            }

            public Member member() {
                return JavaDiscriminatorColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }

            public String annotationName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_COLUMN_ANNOTATION;
            }

            public String annotationElementName() {
                return JavaDiscriminatorColumnModelAdapter.NAME_ANNOTATION_ELEMENT;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildDiscriminatorColumnDefinitionInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setColumnDefinition(newValue);
            }

            public String persValue() {
                return JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.getColumnDefinition();
            }

            public Member member() {
                return JavaDiscriminatorColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }

            public String annotationName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_COLUMN_ANNOTATION;
            }

            public String annotationElementName() {
                return JavaDiscriminatorColumnModelAdapter.COLUMN_DEFINITION_ANNOTATION_ELEMENT;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildDiscriminatorColumnLengthInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.setLength(Integer.parseInt(newValue));
            }

            public String persValue() {
                return Integer.toString(JavaDiscriminatorColumnModelAdapter.this.discriminatorColumn.getLength());
            }

            public Member member() {
                return JavaDiscriminatorColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return "31";
            }

            public String annotationName() {
                return JavaDiscriminatorColumnModelAdapter.DISCRIMINATOR_COLUMN_ANNOTATION;
            }

            public String annotationElementName() {
                return JavaDiscriminatorColumnModelAdapter.LENGTH_ANNOTATION_ELEMENT;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected Member member() {
        return this.member;
    }

    public void setDiscriminatorColumn(DiscriminatorColumn discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public ITextRange getTextRange() {
        return null;
    }

    public void specifiedNameChanged() {
        this.discriminatorColumnSpecifiedNameAdapter.updateJavaElement();
    }

    public void discriminatorTypeChanged() {
        this.discriminatorTypeAdapter.updateJavaElement();
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.discriminatorTypeAdapter.updatePersElement(astRoot);
        this.discriminatorColumnSpecifiedNameAdapter.updatePersElement(astRoot);
        this.discriminatorColumnDefinitionAdapter.updatePersElement(astRoot);
        this.discriminatorColumnLengthAdapter.updatePersElement(astRoot);
    }
}

