/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.impl.PersistenceSourceRefElementImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class JoinColumnImpl
extends PersistenceSourceRefElementImpl
implements JoinColumn {
    protected static final String DEFAULT_TABLE_NAME_EDEFAULT = null;
    protected String defaultTableName = DEFAULT_TABLE_NAME_EDEFAULT;
    protected static final String SPECIFIED_TABLE_NAME_EDEFAULT = null;
    protected String specifiedTableName = SPECIFIED_TABLE_NAME_EDEFAULT;
    protected static final String TABLE_NAME_EDEFAULT = null;
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected static final String DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String defaultReferencedColumnName = DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT;
    protected static final String SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT = null;
    protected String specifiedReferencedColumnName = SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT;
    protected static final String REFERENCED_COLUMN_NAME_EDEFAULT = null;

    protected JoinColumnImpl() {
    }

    protected JoinColumnImpl(IJoinColumnModelAdapter modelAdapter) {
        super(modelAdapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.JOIN_COLUMN;
    }

    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    public void setDefaultTableName(String newDefaultTableName) {
        String oldDefaultTableName = this.defaultTableName;
        this.defaultTableName = newDefaultTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDefaultTableName, (Object)this.defaultTableName));
        }
    }

    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    public void setSpecifiedTableNameGen(String newSpecifiedTableName) {
        String oldSpecifiedTableName = this.specifiedTableName;
        this.specifiedTableName = newSpecifiedTableName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedTableName, (Object)this.specifiedTableName));
        }
    }

    public void setSpecifiedTableName(String newSpecifiedTableName) {
        this.setSpecifiedTableNameGen(newSpecifiedTableName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedTableNameChanged();
    }

    public String getTableName() {
        return this.getSpecifiedTableName() == null ? this.getDefaultTableName() : this.getSpecifiedTableName();
    }

    public Table getTable() {
        Schema schema = this.getPersistenceProject().getSchema();
        return schema == null ? null : schema.tableNamed(this.getTableName());
    }

    public Table getReferencedTable() {
        Entity entity = this.getOwner().relationshipMapping().getResolvedTargetEntity();
        if (entity != null) {
            Schema schema = this.getPersistenceProject().getSchema();
            String tableName = entity.getTable().getName();
            return schema == null ? null : schema.tableNamed(tableName);
        }
        return null;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setSpecifiedNameGen(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    public void setSpecifiedName(String newSpecifiedName) {
        this.setSpecifiedNameGen(newSpecifiedName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedNameChanged();
    }

    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    public void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldDefaultReferencedColumnName, (Object)this.defaultReferencedColumnName));
        }
    }

    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    public void setSpecifiedReferencedColumnNameGen(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSpecifiedReferencedColumnName, (Object)this.specifiedReferencedColumnName));
        }
    }

    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        this.setSpecifiedReferencedColumnNameGen(newSpecifiedReferencedColumnName);
        ((IJoinColumnModelAdapter)this.getModelAdapter()).specifiedReferencedColumnNameChanged();
    }

    public String getReferencedColumnName() {
        return this.getSpecifiedReferencedColumnName() == null ? this.getDefaultReferencedColumnName() : this.getSpecifiedReferencedColumnName();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDefaultTableName();
            }
            case 1: {
                return this.getSpecifiedTableName();
            }
            case 2: {
                return this.getTableName();
            }
            case 3: {
                return this.getDefaultName();
            }
            case 4: {
                return this.getSpecifiedName();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getDefaultReferencedColumnName();
            }
            case 7: {
                return this.getSpecifiedReferencedColumnName();
            }
            case 8: {
                return this.getReferencedColumnName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDefaultTableName((String)newValue);
                return;
            }
            case 1: {
                this.setSpecifiedTableName((String)newValue);
                return;
            }
            case 3: {
                this.setDefaultName((String)newValue);
                return;
            }
            case 4: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 6: {
                this.setDefaultReferencedColumnName((String)newValue);
                return;
            }
            case 7: {
                this.setSpecifiedReferencedColumnName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDefaultTableName(DEFAULT_TABLE_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setSpecifiedTableName(SPECIFIED_TABLE_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setDefaultName(DEFAULT_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setDefaultReferencedColumnName(DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setSpecifiedReferencedColumnName(SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DEFAULT_TABLE_NAME_EDEFAULT == null ? this.defaultTableName != null : !DEFAULT_TABLE_NAME_EDEFAULT.equals(this.defaultTableName);
            }
            case 1: {
                return SPECIFIED_TABLE_NAME_EDEFAULT == null ? this.specifiedTableName != null : !SPECIFIED_TABLE_NAME_EDEFAULT.equals(this.specifiedTableName);
            }
            case 2: {
                return TABLE_NAME_EDEFAULT == null ? this.getTableName() != null : !TABLE_NAME_EDEFAULT.equals(this.getTableName());
            }
            case 3: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 4: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 6: {
                return DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.defaultReferencedColumnName != null : !DEFAULT_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.defaultReferencedColumnName);
            }
            case 7: {
                return SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.specifiedReferencedColumnName != null : !SPECIFIED_REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.specifiedReferencedColumnName);
            }
            case 8: {
                return REFERENCED_COLUMN_NAME_EDEFAULT == null ? this.getReferencedColumnName() != null : !REFERENCED_COLUMN_NAME_EDEFAULT.equals(this.getReferencedColumnName());
            }
        }
        return super.eIsSet(featureID);
    }

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (defaultTableName: ");
        result.append(this.defaultTableName);
        result.append(", specifiedTableName: ");
        result.append(this.specifiedTableName);
        result.append(", defaultName: ");
        result.append(this.defaultName);
        result.append(", specifiedName: ");
        result.append(this.specifiedName);
        result.append(", defaultReferencedColumnName: ");
        result.append(this.defaultReferencedColumnName);
        result.append(", specifiedReferencedColumnName: ");
        result.append(this.specifiedReferencedColumnName);
        result.append(')');
        return result.toString();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        if (((IJoinColumnModelAdapter)this.getModelAdapter()).getOwner().relationshipMapping().getTypeMapping().getKey() == Entity.Key.INSTANCE) {
            this.addJoinColumnTableNotAssociatedWithOwningEntityProblemTo(problems);
            this.addUnresolvedJoinColumnProblemTo(problems);
            this.addUnresolvedReferencedColumnProblemTo(problems);
        }
    }

    private void addJoinColumnTableNotAssociatedWithOwningEntityProblemTo(List problems) {
        String tableName = this.getTableName();
        if (!this.containsString(this.getOwner().relationshipMapping().getTypeMapping().associatedTableIncludingInheritedNames(), tableName)) {
            problems.add(this.buildProblem(this.joinColumnTableNotAssociatedWithOwningEntityMessage(), ((IJoinColumnModelAdapter)this.getModelAdapter()).tableNameTextRange()));
        }
    }

    private boolean containsString(Iterator iterator, String tableName) {
        while (iterator.hasNext()) {
            if (!(this.caseSensitive() ? tableName.equals(iterator.next()) : StringTools.stringsAreEqualIgnoreCase((String)tableName, (String)((String)iterator.next())))) continue;
            return true;
        }
        return false;
    }

    private boolean caseSensitive() {
        return false;
    }

    private IJoinColumnModelAdapter.JoinColumnOwner getOwner() {
        return ((IJoinColumnModelAdapter)this.getModelAdapter()).getOwner();
    }

    protected String joinColumnTableNotAssociatedWithOwningEntityMessage() {
        return "The table " + this.getTableName() + " is not associated with the owning Entity";
    }

    private void addUnresolvedJoinColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getOwner().getTableName(this), this.getName())) {
            problems.add(this.buildProblem("The join column " + this.getName() + " cannot be found on the table " + tableName, this.joinColumnTextRange()));
        }
    }

    private boolean columnResolves(String tableName, String columnName) {
        Table table;
        Schema schema = this.getPersistenceProject().getSchema();
        Table table2 = table = schema == null ? null : schema.tableNamed(tableName);
        if (table == null) {
            return true;
        }
        return table.containsColumnNamed(columnName);
    }

    private ITextRange joinColumnTextRange() {
        ITextRange textRange = ((IJoinColumnModelAdapter)this.getModelAdapter()).joinColumnTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    private void addUnresolvedReferencedColumnProblemTo(List problems) {
        String tableName;
        if (this.getPersistenceProject().getConnection().isConnected() && !this.columnResolves(tableName = this.getOwner().getReferencedTableName(this), this.getReferencedColumnName())) {
            problems.add(this.buildProblem("The referenced column " + this.getReferencedColumnName() + " cannot be found on the table " + tableName, this.referencedColumnTextRange()));
        }
    }

    private ITextRange referencedColumnTextRange() {
        ITextRange textRange = ((IJoinColumnModelAdapter)this.getModelAdapter()).referencedColumnTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    public int indexInContainer() {
        return ((IJoinColumnModelAdapter)this.getModelAdapter()).getOwner().index(this);
    }
}

