/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.RelationshipMappingItemProvider;
import org.eclipse.dali.orm.provider.SingleRelationshipMappingItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinColumnComposite;
import org.eclipse.dali.ui.views.RelationshipMappingComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ManyToOneMappingComposite
extends RelationshipMappingComposite
implements IPersistenceComposite {
    private JoinColumnComposite joinColumnComposite;

    protected ManyToOneMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected RelationshipMappingItemProvider createRelationshipMappingItemProvider(OrmItemProviderAdapterFactory adapterFactory) {
        return (RelationshipMappingItemProvider)adapterFactory.createManyToOneMappingAdapter();
    }

    private void initializeLayout() {
        this.setLayout((Layout)new FillLayout(512));
        TabFolder folder = new TabFolder((Composite)this, 128);
        Control generalControl = this.buildGeneralTab(folder);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(DaliUiMessages.ManyToOneMappingComposite_general);
        generalTab.setControl(generalControl);
        Control joinTableControl = this.buildJoinColumnsTab(folder);
        TabItem joinTableTab = new TabItem(folder, 0);
        joinTableTab.setText(DaliUiMessages.ManyToOneMappingComposite_joinColumns);
        joinTableTab.setControl(joinTableControl);
        folder.setSelection(0);
    }

    private Control buildGeneralTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label targetEntityLabel = new Label(composite, 16384);
        targetEntityLabel.setText(DaliUiMessages.ManyToOneMappingComposite_targetEntity);
        this.targetEntityCombo = this.buildTargetEntityCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(composite);
        Label fetchTypeLabel = new Label(composite, 16384);
        fetchTypeLabel.setText(DaliUiMessages.ManyToOneMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label cascadeTypeLabel = new Label(composite, 16384);
        cascadeTypeLabel.setText(DaliUiMessages.ManyToOneMappingComposite_cacadeType);
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(composite);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label optionalLabel = new Label(composite, 16384);
        optionalLabel.setText(DaliUiMessages.ManyToOneMappingComposite_optional);
        this.optionalComboViewer = this.buildOptionalCombo(composite);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.optionalComboViewer.getCombo().setLayoutData((Object)gridData);
        return composite;
    }

    private Control buildJoinColumnsTab(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.joinColumnComposite = new JoinColumnComposite(composite, this.editingDomain, this.adapterFactory, (SingleRelationshipMappingItemProvider)this.adapterFactory.createManyToOneMappingAdapter());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinColumnComposite.setLayoutData(gridData);
        return composite;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (model != null) {
            this.joinColumnComposite.populate((EObject)this.relationshipMapping);
        } else {
            this.joinColumnComposite.populate(null);
        }
        this.populating = false;
    }

    public void dispose() {
        super.dispose();
        this.joinColumnComposite.dispose();
    }

    public static class ManyToOneMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new ManyToOneMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

