/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.VersionMapping;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.VersionMappingItemProvider;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VersionMappingComposite
extends Composite
implements IPersistenceComposite {
    private ColumnComposite columnComposite;
    private VersionMapping version;
    EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private VersionMappingItemProvider versionTypeItemProvider;
    private INotifyChangedListener mappingListener;
    private ConnectionListener connectionListener;

    protected VersionMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.versionTypeItemProvider = (VersionMappingItemProvider)this.adapterFactory.createVersionMappingAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
    }

    public void populate(EObject model) {
        if (this.version != null) {
            this.versionTypeItemProvider.removeListener(this.getMappingListener());
            this.version.eAdapters().remove((Object)this.versionTypeItemProvider);
        }
        if (model == null) {
            this.version = null;
            this.columnComposite.populate(null);
            return;
        }
        this.version = (VersionMapping)((PersistentAttribute)model).getAttributeMapping();
        this.versionTypeItemProvider.addListener(this.getMappingListener());
        this.version.eAdapters().add((Object)this.versionTypeItemProvider);
        this.populateColumnCombo();
    }

    private void populateColumnCombo() {
        this.addConnectionListener();
        if (this.version == null) {
            this.columnComposite.populate(null);
        } else {
            this.columnComposite.populate((EObject)this.version.getColumn());
        }
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                }
            };
        }
        return this.mappingListener;
    }

    public void dispose() {
        this.removeConnectionListener();
        this.versionTypeItemProvider.removeListener(this.mappingListener);
        super.dispose();
    }

    private void addConnectionListener() {
        if (this.connectionListener == null) {
            Connection connection = this.version.getPersistenceProject().getConnection();
            this.connectionListener = this.buildConnectionListener(connection);
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.version.getPersistenceProject().getConnection().removeConnectionListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    VersionMappingComposite.this.populateColumnCombo();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    VersionMappingComposite.this.populateColumnCombo();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                VersionMappingComposite.this.populateColumnCombo();
            }

            public void tableChanged(Table table) {
                if (VersionMappingComposite.this.version != null && table.getName().equalsIgnoreCase(VersionMappingComposite.this.version.getColumn().getTableName())) {
                    VersionMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    VersionMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    VersionMappingComposite.this.populateColumnCombo();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
            }

            public void dispose() {
            }
        };
    }

    VersionMapping getVerionsMapping() {
        return this.version;
    }

    public static class VersionMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new VersionMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

