/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class JavaAttributeOverrideModelAdapter
implements IAttributeOverrideModelAdapter {
    public static final String ATTRIBUTE_OVERRIDE_ANNOTATION = "AttributeOverride";
    public static final String ATTRIBUTE_OVERRIDES_ANNOTATION = "AttributeOverrides";
    private AttributeOverride attributeOverride;
    private IAttributeOverrideModelAdapter.AttributeOverrideOwner owner;
    private Member member;

    JavaAttributeOverrideModelAdapter(IAttributeOverrideModelAdapter.AttributeOverrideOwner owner) {
        this.owner = owner;
    }

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaAttributeOverrideColumnModelAdapter(this.buildColumnOwner());
    }

    public IAttributeOverrideModelAdapter.AttributeOverrideOwner getOwner() {
        return this.owner;
    }

    private IColumnModelAdapter.ColumnOwner buildColumnOwner() {
        return new IColumnModelAdapter.ColumnOwner(){

            public Table getTableNamed(String tableName) {
                return this.getTypeMapping().getResolvedDBTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return JavaAttributeOverrideModelAdapter.this.getOwner().getTypeMapping();
            }

            public ITextRange getTextRange() {
                return JavaAttributeOverrideModelAdapter.this.attributeOverride.getTextRange();
            }
        };
    }

    public void setAttributeOverride(AttributeOverride attributeOverride) {
        this.attributeOverride = attributeOverride;
    }

    void engage(Member member, CompilationUnit astRoot) {
        this.member = member;
        this.getColumnModelAdapter().engage(member, astRoot);
        this.updatePersModel(astRoot);
    }

    private JavaAttributeOverrideColumnModelAdapter getColumnModelAdapter() {
        return (JavaAttributeOverrideColumnModelAdapter)this.attributeOverride.getColumn().getModelAdapter();
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
        this.getColumnModelAdapter().postUpdatePersModel(astRoot);
    }

    public void nameChanged() {
    }

    public ITextRange getTextRange() {
        BodyDeclaration bodyDeclaration = this.member.bodyDeclaration();
        Annotation annotation = this.getAttributeOverrideAnnotation(bodyDeclaration);
        if (annotation == null) {
            return null;
        }
        return ASTTools.getTextRange((ASTNode)annotation);
    }

    Annotation getAttributeOverrideAnnotation(BodyDeclaration bodyDeclaration) {
        Expression nameStringLiteral;
        MemberValuePair nameValuePair;
        MemberValuePair valueValuePair;
        Annotation attributeOverrideAnnotation = ASTTools.getAnnotation(bodyDeclaration, ATTRIBUTE_OVERRIDE_ANNOTATION);
        if (attributeOverrideAnnotation != null) {
            String annotationName = ASTTools.getAnnotationElementStringValue(bodyDeclaration, ATTRIBUTE_OVERRIDE_ANNOTATION, "name");
            if (annotationName != null && annotationName.equals(this.attributeOverride.getName())) {
                return attributeOverrideAnnotation;
            }
            return null;
        }
        Expression valueExpression = null;
        Annotation attributeOverridesAnnotation = ASTTools.getAnnotation(bodyDeclaration, ATTRIBUTE_OVERRIDES_ANNOTATION);
        if (attributeOverridesAnnotation != null && attributeOverridesAnnotation.isSingleMemberAnnotation()) {
            valueExpression = ((SingleMemberAnnotation)attributeOverridesAnnotation).getValue();
        } else if (attributeOverridesAnnotation != null && attributeOverridesAnnotation.isNormalAnnotation() && (valueValuePair = ASTTools.getMemberValuePair((NormalAnnotation)attributeOverridesAnnotation, "value")) != null) {
            valueExpression = valueValuePair.getValue();
        }
        if (valueExpression == null) {
            return null;
        }
        if (valueExpression.getNodeType() == 4) {
            List expressions = ((ArrayInitializer)valueExpression).expressions();
            int i = 0;
            while (i < expressions.size()) {
                Expression nameStringLiteral2;
                Expression expression = (Expression)expressions.get(i);
                if (expression.getNodeType() == 77 && ((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(ATTRIBUTE_OVERRIDE_ANNOTATION) && (nameStringLiteral2 = ASTTools.getMemberValuePair((NormalAnnotation)expression, "name").getValue()).getNodeType() == 45) {
                    String attributeOverrideName = this.attributeOverride.getName();
                    if (((StringLiteral)nameStringLiteral2).getLiteralValue().equals(attributeOverrideName)) {
                        return (NormalAnnotation)expression;
                    }
                }
                ++i;
            }
        } else if (valueExpression.getNodeType() == 77 && valueExpression.getNodeType() == 77 && ((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(ATTRIBUTE_OVERRIDE_ANNOTATION) && (nameValuePair = ASTTools.getMemberValuePair((NormalAnnotation)valueExpression, "name")) != null && (nameStringLiteral = nameValuePair.getValue()).getNodeType() == 45) {
            String attributeOverrideName = this.attributeOverride.getName();
            if (((StringLiteral)nameStringLiteral).getLiteralValue().equals(attributeOverrideName)) {
                return (NormalAnnotation)valueExpression;
            }
        }
        return null;
    }
}

