/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaColumnModelAdapter
implements IColumnModelAdapter {
    private Column column;
    private IColumnModelAdapter.ColumnOwner owner;
    private StringAnnotationElementAdapter specifiedNameAdapter;
    private StringAnnotationElementAdapter specifiedTableNameAdapter;

    JavaColumnModelAdapter(IColumnModelAdapter.ColumnOwner owner) {
        this.owner = owner;
        this.specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
        this.specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.attribute();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected void updatePersModel(CompilationUnit astRoot) {
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedTableName(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersDefaultTableName();
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private String defaultName() {
        ColumnHolder columnHolder = (ColumnHolder)this.column.eContainer();
        String attributeName = ((PersistentAttribute)columnHolder.eContainer()).getName();
        return attributeName;
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.column.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private String defaultTableName() {
        AttributeMapping attributeMapping = (AttributeMapping)this.column.eContainer();
        TypeMapping typeMapping = attributeMapping.getTypeMapping();
        if (typeMapping.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)typeMapping).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    private Attribute attribute() {
        PersistentAttribute persistentAttribute = ((AttributeMapping)this.column.getParent()).getPersistentAttribute();
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)persistentAttribute.getModelAdapter();
        return modelAdapter.getAttribute();
    }

    public ITextRange getTextRange() {
        ITextRange textRange = this.attribute().getTextRange("Column");
        if (textRange != null) {
            return textRange;
        }
        return this.owner.getTextRange();
    }

    public ITextRange nameTextRange() {
        ITextRange nameTextRange = this.specifiedNameAdapter.textRange();
        if (nameTextRange == null) {
            return this.getTextRange();
        }
        return nameTextRange;
    }

    public ITextRange tableNameTextRange() {
        ITextRange textRange = this.specifiedTableNameAdapter.textRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    public IColumnModelAdapter.ColumnOwner getOwner() {
        return this.owner;
    }
}

