/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ProjectAction
implements IObjectActionDelegate {
    private ISelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    protected IStructuredSelection getCurrentSelection() {
        if (this.currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)this.currentSelection;
        }
        return null;
    }

    public void run(IAction action) {
        if (this.currentSelection instanceof IStructuredSelection) {
            Iterator stream = ((IStructuredSelection)this.currentSelection).iterator();
            while (stream.hasNext()) {
                this.execute(stream.next());
            }
        }
    }

    protected void execute(Object selection) {
        IProject project = this.projectFromSelection(selection);
        if (project != null) {
            this.execute(project);
        }
    }

    protected IProject projectFromSelection(Object selection) {
        if (selection instanceof IProject) {
            return (IProject)selection;
        }
        if (selection instanceof IJavaProject) {
            return ((IJavaProject)selection).getProject();
        }
        return null;
    }

    protected void execute(IProject project) {
        PersistenceProject persistenceProject = DaliPlugin.persistenceProject((IProject)project);
        if (persistenceProject == null) {
            return;
        }
        this.execute(persistenceProject);
    }

    protected void execute(PersistenceProject project) {
        throw new UnsupportedOperationException();
    }
}

