/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.composites;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class PageBookManager
extends PageBook {
    private Map pageRecords;
    private Object active;
    private PageBook pageBook;
    private Composite defaultComposite;

    public PageBookManager(Composite parent, String aDefaultLabel) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.pageRecords = new HashMap();
        this.pageBook = new PageBook((Composite)this, 0);
        this.defaultComposite = new DefaultComposite((Composite)this.pageBook, aDefaultLabel);
        this.pageBook.showPage((Control)this.defaultComposite);
    }

    public boolean activate(Object anObj) {
        if (!anObj.equals(this.active) && this.pageRecords.containsKey(anObj)) {
            Composite composite = (Composite)this.pageRecords.get(anObj);
            this.pageBook.showPage((Control)composite);
            this.active = anObj;
            return true;
        }
        if (!anObj.equals(this.active) && !this.pageRecords.containsKey(anObj)) {
            this.pageBook.showPage((Control)this.defaultComposite);
            this.active = null;
        }
        return false;
    }

    public boolean deactivate(Object anObj) {
        if (anObj.equals(this.active)) {
            this.pageBook.showPage((Control)this.defaultComposite);
            this.active = null;
            return true;
        }
        return false;
    }

    public Composite put(Object anObj, Composite aComposite) {
        Composite composite = this.pageRecords.put(anObj, aComposite);
        this.activate(anObj);
        return composite;
    }

    public Composite remove(Object anObj) {
        if (anObj.equals(this.active)) {
            this.active = null;
            this.pageBook.showPage((Control)this.defaultComposite);
        }
        return (Composite)this.pageRecords.remove(anObj);
    }

    public boolean contains(Object anObj) {
        return this.pageRecords.containsKey(anObj);
    }

    public Composite getActive() {
        if (this.active == null) {
            return this.defaultComposite;
        }
        return (Composite)this.pageRecords.get(this.active);
    }

    public Composite getComposite() {
        return this.pageBook;
    }

    public void dispose() {
        super.dispose();
        Collection composites = this.pageRecords.values();
        Iterator i = composites.iterator();
        while (i.hasNext()) {
            ((Composite)i.next()).dispose();
        }
    }

    private class DefaultComposite
    extends Composite {
        public DefaultComposite(Composite aParent, String aDefaultLabel) {
            super(aParent, 0);
            this.setLayout((Layout)new FillLayout(512));
            Label label = new Label((Composite)this, 16384);
            label.setText(aDefaultLabel);
        }
    }
}

