/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.CascadeType;
import org.eclipse.dali.orm.FetchType;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.SingleRelationshipMapping;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.RelationshipMappingItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class RelationshipMappingComposite
extends Composite {
    protected boolean populating;
    protected EditingDomain editingDomain;
    protected OrmItemProviderAdapterFactory adapterFactory;
    protected ComboViewer fetchTypeComboViewer;
    protected ComboViewer cascadeTypeComboViewer;
    protected ComboViewer optionalComboViewer;
    protected Combo targetEntityCombo;
    protected RelationshipMapping relationshipMapping;
    private RelationshipMappingItemProvider mappingTypeItemProvider;
    private INotifyChangedListener mappingTypeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RelationshipMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.initialize(adapterFactory);
    }

    protected void initialize(OrmItemProviderAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.mappingTypeItemProvider = this.createRelationshipMappingItemProvider(adapterFactory);
    }

    protected abstract RelationshipMappingItemProvider createRelationshipMappingItemProvider(OrmItemProviderAdapterFactory var1);

    protected ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RelationshipMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchType fetchType = (FetchType)selection.getFirstElement();
                    RelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)RelationshipMappingComposite.this.editingDomain, (Object)RelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getRelationshipMapping_FetchType(), (Object)fetchType));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewer.getCombo(), "org.eclipse.dali.ui.mapping_fetchType");
        return viewer;
    }

    protected ComboViewer buildCascadeTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(CascadeType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RelationshipMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    CascadeType cascadeType = (CascadeType)selection.getFirstElement();
                    RelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)RelationshipMappingComposite.this.editingDomain, (Object)RelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getRelationshipMapping_CascadeType(), (Object)cascadeType));
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewer.getCombo(), "org.eclipse.dali.ui.mapping_cascadeType");
        return viewer;
    }

    protected ComboViewer buildOptionalCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Optional.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RelationshipMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    Optional optional = (Optional)selection.getFirstElement();
                    if (!((SingleRelationshipMapping)RelationshipMappingComposite.this.relationshipMapping).getOptional().equals(optional)) {
                        RelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)RelationshipMappingComposite.this.editingDomain, (Object)RelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getSingleRelationshipMapping_Optional(), (Object)optional));
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)viewer.getCombo(), "org.eclipse.dali.ui.mapping_optional");
        return viewer;
    }

    protected Combo buildTargetEntityCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add(DaliUiMessages.RelationshipMappingComposite_defaultEmpty);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RelationshipMappingComposite.this.populating) {
                    return;
                }
                String targetEntityName = ((Combo)e.getSource()).getText();
                if (targetEntityName.equals(combo.getItem(0)) || targetEntityName.equals("")) {
                    targetEntityName = null;
                } else if (!RelationshipMappingComposite.this.relationshipMapping.isValidTargetEntity(targetEntityName)) {
                    return;
                }
                RelationshipMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)RelationshipMappingComposite.this.editingDomain, (Object)RelationshipMappingComposite.this.relationshipMapping, (Object)OrmPackage.eINSTANCE.getRelationshipMapping_SpecifiedTargetEntity(), (Object)targetEntityName));
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "org.eclipse.dali.ui.mapping_targetEntity");
        return combo;
    }

    public void populate(EObject model) {
        Optional optional;
        this.populating = true;
        if (this.relationshipMapping != null) {
            this.mappingTypeItemProvider.removeListener(this.getMappingTypeListener());
            this.relationshipMapping.eAdapters().remove((Object)this.mappingTypeItemProvider);
        }
        if (model == null) {
            return;
        }
        this.relationshipMapping = (RelationshipMapping)((PersistentAttribute)model).getAttributeMapping();
        this.mappingTypeItemProvider.addListener(this.getMappingTypeListener());
        this.relationshipMapping.eAdapters().add((Object)this.mappingTypeItemProvider);
        if (this.relationshipMapping.getFetchType() == FetchType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.DEFAULT_LITERAL));
            }
        } else if (this.relationshipMapping.getFetchType() == FetchType.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.LAZY_LITERAL));
        }
        this.cascadeTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.relationshipMapping.getCascadeType()));
        String targetEntity = this.relationshipMapping.getSpecifiedTargetEntity();
        this.targetEntityCombo.setItem(0, NLS.bind((String)DaliUiMessages.RelationshipMappingComposite_defaultWithOneParam, (Object)this.relationshipMapping.getDefaultTargetEntity()));
        if (targetEntity != null) {
            if (!this.targetEntityCombo.getText().equals(targetEntity)) {
                this.targetEntityCombo.setText(targetEntity);
            }
        } else if (this.targetEntityCombo.getSelectionIndex() != 0) {
            this.targetEntityCombo.select(0);
        }
        if (this.optionalComboViewer != null && (optional = ((SingleRelationshipMapping)this.relationshipMapping).getOptional()) != ((StructuredSelection)this.optionalComboViewer.getSelection()).getFirstElement()) {
            this.optionalComboViewer.setSelection((ISelection)new StructuredSelection((Object)optional));
        }
        this.populating = false;
    }

    private INotifyChangedListener getMappingTypeListener() {
        if (this.mappingTypeListener == null) {
            this.mappingTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    RelationshipMappingComposite.this.mappingTypeChanged(notification);
                }
            };
        }
        return this.mappingTypeListener;
    }

    protected void mappingTypeChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.RelationshipMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 0) {
            final FetchType fetchType = (FetchType)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (((StructuredSelection)RelationshipMappingComposite.this.fetchTypeComboViewer.getSelection()).getFirstElement() != fetchType) {
                        RelationshipMappingComposite.this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)fetchType));
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.RelationshipMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 1) {
                final CascadeType cascadeType = (CascadeType)notification.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (((StructuredSelection)RelationshipMappingComposite.this.cascadeTypeComboViewer.getSelection()).getFirstElement() != cascadeType) {
                            RelationshipMappingComposite.this.cascadeTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)cascadeType));
                        }
                    }
                });
            } else {
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.dali.orm.RelationshipMapping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz3) == 3) {
                    final String targetEntity = notification.getNewStringValue();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (targetEntity == null) {
                                if (RelationshipMappingComposite.this.targetEntityCombo.getSelectionIndex() != 0) {
                                    RelationshipMappingComposite.this.targetEntityCombo.select(0);
                                }
                            } else if (!RelationshipMappingComposite.this.targetEntityCombo.getText().equals(targetEntity)) {
                                RelationshipMappingComposite.this.targetEntityCombo.setText(targetEntity);
                            }
                        }
                    });
                } else {
                    Class<?> clazz4 = class$0;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$0 = Class.forName("org.eclipse.dali.orm.RelationshipMapping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz4) == 2) {
                        final String defaultTargetEntity = (String)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                int selectionIndex = RelationshipMappingComposite.this.targetEntityCombo.getSelectionIndex();
                                RelationshipMappingComposite.this.targetEntityCombo.setItem(0, NLS.bind((String)DaliUiMessages.RelationshipMappingComposite_defaultWithOneParam, (Object)defaultTargetEntity));
                                if (selectionIndex == 0) {
                                    RelationshipMappingComposite.this.targetEntityCombo.select(0);
                                }
                            }
                        });
                    } else if (this.optionalComboViewer != null) {
                        Class<?> clazz5 = class$1;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$1 = Class.forName("org.eclipse.dali.orm.SingleRelationshipMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (notification.getFeatureID((Class)clazz5) == 8) {
                            final Optional optional = (Optional)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    if (((StructuredSelection)RelationshipMappingComposite.this.optionalComboViewer.getSelection()).getFirstElement() != optional) {
                                        RelationshipMappingComposite.this.optionalComboViewer.setSelection((ISelection)new StructuredSelection((Object)optional));
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    protected Button buildTargetEntitySelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(DaliUiMessages.RelationshipMappingComposite_browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationshipMappingComposite.this.browse();
            }
        });
        return button;
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.targetEntityCombo.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                RelationshipMappingComposite.this.doOpenSelectionDialog();
            }
        });
    }

    private void doOpenSelectionDialog() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        dialog.setTitle("Select Type");
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getResult()[0];
            this.targetEntityCombo.setText(type.getFullyQualifiedName('$'));
        }
    }

    public boolean setFocus() {
        super.setFocus();
        return this.targetEntityCombo.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.relationshipMapping.eAdapters().remove((Object)this.mappingTypeItemProvider);
    }
}

