/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.IPersistenceFileModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistenceFileModelAdapter
implements IPersistenceFileModelAdapter {
    private PersistenceFile persistenceFile;
    private ICompilationUnit compilationUnit;
    private JavaPersistentTypeModelAdapter persistentTypeModelAdapter;

    public void setPersistenceFile(PersistenceFile persistenceFile) {
        this.persistenceFile = persistenceFile;
    }

    public void updatePersModel() {
        this.compilationUnit = JavaCore.createCompilationUnitFrom((IFile)this.persistenceFile.getFile());
        this.updateModel();
    }

    public void handleEvent(ElementChangedEvent event) {
        this.synchWithJavaDelta(event.getDelta());
    }

    private void updateModel() {
        this.updatePrimaryType();
    }

    private void synchWithJavaDelta(IJavaElementDelta delta) {
        boolean processChildren = false;
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                processChildren = true;
                break;
            }
            case 5: {
                break;
            }
            default: {
                return;
            }
        }
        if (processChildren) {
            ArrayIterator stream = new ArrayIterator((Object[])delta.getAffectedChildren());
            while (stream.hasNext()) {
                this.synchWithJavaDelta((IJavaElementDelta)stream.next());
            }
        }
        if (!delta.getElement().equals(this.compilationUnit)) {
            return;
        }
        if ((delta.getFlags() & 0x10000) != 0 || (delta.getFlags() & 0x20) != 0 || (delta.getFlags() & 0x10) != 0) {
            return;
        }
        if ((delta.getFlags() & 8) != 0 || (delta.getFlags() & 0x80000) != 0) {
            this.updatePrimaryType();
        }
        if (this.persistentTypeModelAdapter != null) {
            CompilationUnit astRoot = this.persistentTypeModelAdapter.getType().createASTRoot();
            this.persistentTypeModelAdapter.synchWithJavaDelta(delta, astRoot);
        }
    }

    private void updatePrimaryType() {
        IType primaryType = this.compilationUnit.findPrimaryType();
        try {
            if (primaryType == null || primaryType.isAnnotation() || primaryType.isEnum()) {
                if (this.persistentTypeModelAdapter != null) {
                    this.removePersistentType();
                }
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            if (this.persistentTypeModelAdapter != null) {
                this.removePersistentType();
            }
            return;
        }
        CompilationUnit astRoot = JDTTools.createASTRoot((IMember)primaryType);
        if (primaryType != null && this.persistentTypeModelAdapter == null) {
            try {
                if (!primaryType.isAnnotation() && !primaryType.isEnum()) {
                    this.addPersistentType(primaryType, astRoot);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (!primaryType.equals(this.persistentTypeModelAdapter.getJDTType())) {
            this.removePersistentType();
            try {
                if (!primaryType.isAnnotation() && !primaryType.isEnum()) {
                    this.addPersistentType(primaryType, astRoot);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void addPersistentType(IType primaryType, CompilationUnit astRoot) {
        this.persistentTypeModelAdapter = new JavaPersistentTypeModelAdapter(primaryType);
        PersistentType persistentType = OrmFactory.eINSTANCE.createPersistentType(this.persistentTypeModelAdapter);
        this.persistentTypeModelAdapter.updatePersModel(astRoot);
        this.persistenceFile.getPersistentTypes().add((Object)persistentType);
    }

    private void removePersistentType() {
        PersistentType persistentType = this.persistentTypeModelAdapter.getPersistentType();
        this.persistentTypeModelAdapter.disengage();
        this.persistenceFile.getPersistentTypes().remove((Object)persistentType);
        this.persistentTypeModelAdapter = null;
    }

    public ITextRange getTextRange() {
        return null;
    }

    public void postUpdatePersModel() {
        IType type = this.compilationUnit.findPrimaryType();
        try {
            if (type != null && !type.isAnnotation() && !type.isEnum()) {
                CompilationUnit astRoot = JDTTools.createASTRoot((IMember)type);
                this.persistentTypeModelAdapter.postUpdatePersModel(astRoot);
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

