/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.IProblem;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.adapters.IAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.IJavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StringLiteral;

abstract class JavaAttributeMappingModelAdapter
implements IJavaAttributeMappingModelAdapter {
    private AttributeMapping attributeMapping;
    private Attribute attribute;

    protected JavaAttributeMappingModelAdapter() {
    }

    public final AttributeMapping createAttributeMapping(boolean isDefault, Attribute mappedAttribute) {
        this.attribute = mappedAttribute;
        this.attributeMapping = this.buildAttributeMapping(isDefault);
        return this.attributeMapping;
    }

    protected abstract AttributeMapping buildAttributeMapping(boolean var1);

    protected AttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    protected Attribute getAttribute() {
        return this.attribute;
    }

    protected String getAttributeClassName() {
        String[][] resolvedType;
        String signature = this.getAttribute().getTypeSignature();
        String simpleName = Signature.getSignatureSimpleName((String)signature);
        String qualifier = Signature.getSignatureQualifier((String)signature);
        String qualifiedName = simpleName;
        if (!StringTools.stringIsEmpty((String)qualifier)) {
            qualifiedName = String.valueOf(qualifier) + "." + simpleName;
        }
        try {
            resolvedType = this.getType().resolveType(qualifiedName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        if (resolvedType == null || resolvedType.length > 1) {
            return null;
        }
        String packageName = resolvedType[0][0];
        String fullyQualifiedClassName = qualifiedName;
        if (!StringTools.stringIsEmpty((String)packageName)) {
            fullyQualifiedClassName = String.valueOf(packageName) + "." + qualifiedName;
        }
        return fullyQualifiedClassName;
    }

    protected IType getType() {
        return this.getType(this.getAttribute());
    }

    protected IType getType(Attribute attribute) {
        return attribute.getJDTMember().getDeclaringType();
    }

    protected IType getTypeNamed(String fullyQualifiedClassName) {
        try {
            return this.getAttribute().getJDTMember().getCompilationUnit().getJavaProject().findType(fullyQualifiedClassName);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    protected String javaPersistentAttributeType(CompilationUnit astRoot) {
        Iterator i = DaliPlugin.getPlugin().possibleAnnotationsMappings();
        while (i.hasNext()) {
            String annotationName = (String)i.next();
            if (!this.containsAnnotation(annotationName, astRoot)) continue;
            return annotationName;
        }
        return null;
    }

    protected String getAnnotationElementString(String annotationElementName, CompilationUnit astRoot) {
        MemberValuePair valuePair = ASTTools.memberValuePair(this.attribute.bodyDeclaration(astRoot), ((IAttributeMappingModelAdapter)this.attributeMapping.getModelAdapter()).attributeMappingName(), annotationElementName);
        if (valuePair != null) {
            if (valuePair.getValue().getNodeType() == 40) {
                return ((QualifiedName)valuePair.getValue()).getName().getFullyQualifiedName();
            }
            if (valuePair.getValue().getNodeType() == 45) {
                return ((StringLiteral)valuePair.getValue()).getLiteralValue();
            }
        }
        return null;
    }

    protected void addMappingAnnotation(String mappingName) {
        this.attribute.addAnnotation(mappingName);
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return ASTTools.annotation(this.attribute.bodyDeclaration(astRoot), annotationName);
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        BodyDeclaration bodyDeclaration = this.attribute.bodyDeclaration(astRoot);
        if (bodyDeclaration != null) {
            return ASTTools.containsAnnotationElement(bodyDeclaration, annotationName, elementName);
        }
        return false;
    }

    public void removeAnnotation(final String annotationName) {
        this.attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation(bodyDeclaration, annotationName);
            }
        });
    }

    public void removeAnnotationElementNamed(final String annotationName, final String elementName) {
        this.attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair valuePairToRemove;
                Annotation annotation = ASTTools.annotation(bodyDeclaration, annotationName);
                if (annotation.isNormalAnnotation() && (valuePairToRemove = ASTTools.memberValuePair((NormalAnnotation)annotation, elementName)) != null) {
                    if (((NormalAnnotation)annotation).values().size() == 1) {
                        MarkerAnnotation newAnnotation = bodyDeclaration.getAST().newMarkerAnnotation();
                        newAnnotation.setTypeName((Name)bodyDeclaration.getAST().newSimpleName(annotationName));
                        ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)newAnnotation);
                    } else {
                        ASTTools.removeValuePair((NormalAnnotation)annotation, valuePairToRemove);
                    }
                }
            }
        });
    }

    protected String javaSpecifiedColumn(CompilationUnit astRoot) {
        Annotation annotation = this.getAnnotation("Column", astRoot);
        if (annotation == null || !annotation.isNormalAnnotation()) {
            return null;
        }
        MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)annotation, "name");
        if (valuePair != null && valuePair.getValue().getNodeType() == 45) {
            return ((StringLiteral)valuePair.getValue()).getLiteralValue();
        }
        return null;
    }

    public void addMappingAnnotation() {
        if (!this.attributeMapping.isDefault()) {
            this.addMappingAnnotation(this.attributeMappingName());
        }
    }

    public ITextRange getTextRange() {
        return this.getAttribute().getTextRange(this.attributeMappingName());
    }

    public void updatePersModel(CompilationUnit astRoot) {
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
    }

    public void addProblemsTo(List problems) {
    }

    public IProblem buildProblem(String message, ITextRange textRange) {
        return new Problem(message, textRange);
    }

    private static class Problem
    implements IProblem {
        private String message;
        private ITextRange textRange;

        Problem(String message, ITextRange textRange) {
            this.message = message;
            this.textRange = textRange;
        }

        public int getCharEnd() {
            return this.textRange.getOffset() + this.textRange.getLength();
        }

        public int getCharStart() {
            return this.textRange.getOffset();
        }

        public int getLineNumber() {
            return this.textRange.getLineNumber();
        }

        public String getMessage() {
            return this.message;
        }
    }
}

