/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractJavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.ColumnInfoAdapter;
import org.eclipse.dali.orm.adapters.java.ColumnInsertableInfo;
import org.eclipse.dali.orm.adapters.java.ColumnUpdatableInfo;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaColumnModelAdapter
extends AbstractJavaColumnModelAdapter {
    private StringAnnotationElementAdapter specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
    private StringAnnotationElementAdapter specifiedTableNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedTableNameElementInfo());
    private BooleanAnnotationElementAdapter insertableAdapter = new BooleanAnnotationElementAdapter(this.buildInsertableInfo());
    private BooleanAnnotationElementAdapter updatableAdapter = new BooleanAnnotationElementAdapter(this.buildUpdatableInfo());

    JavaColumnModelAdapter(Member member, IColumnModelAdapter.ColumnOwner owner) {
        super(member, owner);
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildInsertableInfo() {
        return new ColumnInsertableInfo(this.buildColumnInfoAdapter());
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildUpdatableInfo() {
        return new ColumnUpdatableInfo(this.buildColumnInfoAdapter());
    }

    private ColumnInfoAdapter buildColumnInfoAdapter() {
        return new ColumnInfoAdapter(){

            public Column column() {
                return JavaColumnModelAdapter.this.column;
            }

            public Member member() {
                return JavaColumnModelAdapter.this.member();
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedTableNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaColumnModelAdapter.this.column.setSpecifiedTableName(newValue);
            }

            public String persValue() {
                return JavaColumnModelAdapter.this.column.getSpecifiedTableName();
            }

            public String annotationElementName() {
                return "table";
            }

            public String annotationName() {
                return "Column";
            }

            public Member member() {
                return JavaColumnModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected void updatePersModel(CompilationUnit astRoot) {
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedTableName(astRoot);
        this.updatePersInsertable(astRoot);
        this.updatePersUpdatable(astRoot);
    }

    private void updatePersInsertable(CompilationUnit astRoot) {
        this.insertableAdapter.updatePersElement(astRoot);
    }

    private void updatePersUpdatable(CompilationUnit astRoot) {
        this.updatableAdapter.updatePersElement(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersDefaultTableName();
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private String defaultName() {
        ColumnHolder columnHolder = (ColumnHolder)this.column.eContainer();
        String attributeName = ((PersistentAttribute)columnHolder.eContainer()).getName();
        return attributeName;
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.column.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        this.specifiedTableNameAdapter.updatePersElement(astRoot);
    }

    private String defaultTableName() {
        AttributeMapping attributeMapping = (AttributeMapping)this.column.eContainer();
        TypeMapping typeMapping = attributeMapping.getTypeMapping();
        if (typeMapping.getKey() == Entity.Key.INSTANCE) {
            return ((Entity)typeMapping).getTable().getName();
        }
        return null;
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    public void specifiedTableNameChanged() {
        this.specifiedTableNameAdapter.updateJavaElement();
    }

    public void insertableChanged() {
        this.insertableAdapter.updateJavaElement();
    }

    public void updatableChanged() {
        this.updatableAdapter.updateJavaElement();
    }

    public ITextRange getTextRange() {
        ITextRange textRange = this.member().getTextRange("Column");
        if (textRange != null) {
            return textRange;
        }
        return this.getOwner().getTextRange();
    }

    public ITextRange nameTextRange() {
        ITextRange nameTextRange = this.specifiedNameAdapter.textRange();
        if (nameTextRange == null) {
            return this.getTextRange();
        }
        return nameTextRange;
    }

    public ITextRange tableNameTextRange() {
        ITextRange textRange = this.specifiedTableNameAdapter.textRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }
}

