/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.VersionMapping;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.VersionMappingItemProvider;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VersionMappingComposite
extends Composite
implements IPersistenceComposite {
    private ColumnComposite columnComposite;
    private VersionMapping versionMapping;
    EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private VersionMappingItemProvider versionTypeItemProvider;
    private INotifyChangedListener mappingListener;

    protected VersionMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.versionTypeItemProvider = (VersionMappingItemProvider)this.adapterFactory.createVersionMappingAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
    }

    public void populate(EObject model) {
        this.disengageListeners();
        if (model == null) {
            this.versionMapping = null;
            this.columnComposite.populate(null);
            return;
        }
        this.versionMapping = (VersionMapping)model;
        this.engageListeners();
        this.populateColumnCombo();
    }

    private void engageListeners() {
        this.versionTypeItemProvider.addListener(this.getMappingListener());
        this.getVersionMapping().eAdapters().add((Object)this.versionTypeItemProvider);
    }

    private void disengageListeners() {
        if (this.getVersionMapping() != null) {
            this.versionTypeItemProvider.removeListener(this.getMappingListener());
            this.getVersionMapping().eAdapters().remove((Object)this.versionTypeItemProvider);
        }
    }

    private void populateColumnCombo() {
        this.columnComposite.populate((EObject)this.getVersionMapping().getColumn());
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                }
            };
        }
        return this.mappingListener;
    }

    public void dispose() {
        this.disengageListeners();
        this.columnComposite.dispose();
        super.dispose();
    }

    protected VersionMapping getVersionMapping() {
        return this.versionMapping;
    }

    public static class VersionMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new VersionMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

